#ifndef LORE_H
#define LORE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Lore Class
@brief Library for displaying tips about the game after every round
@author Ozoemena Adrian Ikenna
@date 8th May 2019
*/
class Lore
{
    public:
    /** constructor */
    Lore();
    /** destructor */
    ~Lore();
    
    /** Displays a random tip about the game
    *@param &lcd address of the N5110 library used for the lcd display
    *@param rand random number generated in main function and scaled for use in class
    */
    void display(N5110 &lcd, int rand);
    /** Prints a tip about the enemy ship, seeker, on screen
    *@param &lcd address of the N5110 library used for the lcd display
    */
    void seeker(N5110 &lcd);
    /** Prints a tip about the enemy ship, shooter, on screen
    *@param &lcd address of the N5110 library used for the lcd display
    */
    void shooter(N5110 &lcd);
    /** Prints a tip about a player ship, imperion, on screen
    *@param &lcd address of the N5110 library used for the lcd display
    */
    void imperion(N5110 &lcd);
    /** Prints a tip about a player ship, kestrel, on screen
    *@param &lcd address of the N5110 library used for the lcd display
    */
    void kestrel(N5110 &lcd);
    /** Prints a tip about a player ship, orion, on screen
    *@param &lcd address of the N5110 library used for the lcd display
    */
    void orion(N5110 &lcd);
    /** Prints a tip about the menu on screen
    *@param &lcd address of the N5110 library used for the lcd display
    */
    void menu1(N5110 &lcd);
    /** Displays game intro
    *@param &lcd address of the N5110 library used for the lcd display
    */
    void intro(N5110 &lcd);
    /** Displays game information
    *@param &lcd address of the N5110 library used for the lcd display
    */
    void help(N5110 &lcd);
    /** Holds the info displayed in intro about game
    *@param &lcd address of the N5110 library used for the lcd display
    */
    void ships1(N5110 &lcd);

    private:
    
};
#endif