#include "Lore.h"
// ship sprites
const int seekerSprite[7][9] = {
    {1,1,0,0,0,0,0,1,1},
    {1,0,1,0,0,0,1,0,1},
    {1,0,0,1,1,1,0,0,1},
    {0,1,0,0,0,0,0,1,0},
    {0,0,1,0,0,0,1,0,0},
    {0,0,1,1,0,1,1,0,0},
    {0,0,0,0,1,0,0,0,0},
};
const int shooterSprite[10][11] = {
    {0,0,1,0,0,0,0,0,1,0,0},
    {0,1,0,1,0,0,0,1,0,1,0},
    {1,0,0,1,0,1,0,1,0,0,1},
    {1,0,0,1,1,0,1,1,0,0,1},
    {0,1,0,0,0,0,0,0,0,1,0},
    {0,1,0,0,1,1,1,0,0,1,0},
    {0,0,1,0,0,1,0,0,1,0,0},
    {0,0,0,1,0,0,0,1,0,0,0},
    {0,0,0,0,1,0,1,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,0,0},
};
const int orionSprite[10][7] = {
    {0,0,0,1,0,0,0},
    {0,0,1,0,1,0,0},
    {0,1,0,0,0,1,0},
    {1,0,0,1,0,0,1},
    {0,1,0,0,0,1,0},
    {0,0,1,0,1,0,0},
    {1,0,0,1,0,0,1},
    {1,0,1,0,1,0,1},
    {1,1,0,0,0,1,1},
    {1,0,0,0,0,0,1},

};
const int seekerSpriteLarge[14][17] = {
    {1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1},
    {1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1},
    {1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,1},
    {1,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,1},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0},
    {0,0,1,0,0,0,0,1,0,1,0,0,0,0,1,0,0},
    {0,0,0,1,0,0,0,1,0,1,0,0,0,1,0,0,0},
    {0,0,0,1,0,0,0,1,0,1,0,0,0,1,0,0,0},
    {0,0,0,1,0,0,0,1,0,1,0,0,0,1,0,0,0},
    {0,0,0,1,1,1,0,0,1,0,0,1,1,1,0,0,0},
    {0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0},


};

// Constructor
Lore::Lore()
{

}
// Destructor
Lore::~Lore()
{

}
void Lore::help(N5110 &lcd)
{
    // display help
    lcd.clear();
    lcd.refresh();
    ships1(lcd);
    lcd.refresh();
}
void Lore::display(N5110 &lcd,int rand)
{
    // set the output to be a random number between 0 and 6
    int random = rand%6;
    lcd.clear();
    lcd.refresh();
    // Display a random tip
    switch (random) {
        case 0:
            shooter(lcd);
            break;
        case 1:
            seeker(lcd);
            break;
        case 2:
            kestrel(lcd);
            break;
        case 3:
            orion(lcd);
            break;
        case 4:
            imperion(lcd);
            break;
        case 5:
            menu1(lcd);
            break;
    }
    lcd.refresh();
    wait(3);

}

void Lore::seeker(N5110 &lcd)
{
    lcd.drawSprite(33,5,14,17,(int *)seekerSpriteLarge);
    lcd.printString("   Seekers ",2,3);
    lcd.printString("   explode ",2,4);
    lcd.printString("  on impact ",2,5);
}
void Lore::shooter(N5110 &lcd)
{
    lcd.drawSprite(16,2,10,11,(int *)shooterSprite);
    lcd.drawSprite(38,5,10,11,(int *)shooterSprite);
    lcd.drawSprite(59,2,10,11,(int *)shooterSprite);
    lcd.printString("Shooters will",2,2);
    lcd.printString(" allign next ",2,3);
    lcd.printString("to you before",2,4);
    lcd.printString("  they fire",2,5);
}
void Lore::kestrel(N5110 &lcd)
{
    lcd.printString("the kestrel's",2,0);
    lcd.printString("fire rate  ",2,1);
    lcd.printString("increases the",2,2);
    lcd.printString("  closer you",2,3);
    lcd.printString("are to danger",2,4);
}
void Lore::imperion(N5110 &lcd)
{
    lcd.printString("the imperion ",2,0);
    lcd.printString("  excels in  ",2,1);
    lcd.printString("damage output ",2,2);
    lcd.printString("    but is ",2,3);
    lcd.printString("   immobile ",2,4);
    lcd.printString("during firing ",2,5);
}
void Lore::orion(N5110 &lcd)
{
    lcd.drawSprite(70,34,10,7,(int *)orionSprite);
    lcd.drawLine(70 + 2,34 + 2,45,30,FILL_BLACK);
    lcd.drawLine(70 + 2,34 + 2,55,48,FILL_BLACK);
    lcd.printString("the orion is",2,0);
    lcd.printString("the only ship",2,1);
    lcd.printString("capable of ",2,2);
    lcd.printString("harming",2,3);
    lcd.printString("escaping ",2,4);
    lcd.printString("enemies ",2,5);
}
void Lore::menu1(N5110 &lcd)
{
    lcd.printString("  you can ",2,0);
    lcd.printString(" switch ships ",2,1);
    lcd.printString(" in the menu ",2,2);
    lcd.printString("some are better",2,3);
    lcd.printString(" for certain ",2,4);
    lcd.printString("   tasks. ",2,5);
}

void Lore::ships1(N5110 &lcd)
{
    lcd.printString("You have a",2,0);
    lcd.printString("choice of ",2,1);
    lcd.printString("three ships,",2,2);
    lcd.printString(" press a to ",2,3);
    lcd.printString("fire weapons ",2,4); 
}

void Lore::intro(N5110 &lcd)
{
    lcd.clear();
    lcd.refresh();
    lcd.printString("You're tasked",2,0);
    lcd.printString(" with holding",2,1);
    lcd.printString("   the line ",2,2);
    lcd.printString("   from an ",2,3);
    lcd.printString("invading army ",2,4);
    lcd.refresh();
    wait(2);
    lcd.clear();
    lcd.refresh();
    lcd.printString("    as an  ",2,0);
    lcd.printString(" expendable ",2,1);
    lcd.printString("    asset, ",2,2);
    lcd.printString(" you are not ",2,3);
    lcd.printString(" expected to",2,4);
    lcd.printString("   survive  ",2,5);
    lcd.refresh();
    wait(1);
}
