#include "Health.h"
Health::Health()
{

}

Health::~Health()
{

}
// ship health bar sprites
const int kestrel_h[45][3] =   {
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1},
};

const int imperion_h[45][3] =   {
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1},

};
const int orion_h[45][3] = {
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1},
};
// Note when only refering to health or shields functions will be named after them,
// if a function affects both it will be named with HP
void Health::init(SHIP shipUsed)
{
    // assign health and shield values based on the ship
    switch (shipUsed) {
        case kestrel:
            _ship_shields = 45;
            _ship_health = 11;
            _health_unit = 4;
            break;
        case imperion:
            _ship_shields = 30;
            _ship_health = 6;
            _health_unit = 7;
            break;
        case orion:
            _ship_shields = 70;
            _ship_health = 2;
            _health_unit = 22;
            break;
    }
    _seekerH[0] = 10;
    _seekerH[1] = 10;
    _seekerH[2] = 10;
    _shooterH[0] = 30;
    _shooterH[1] = 30;
    _shooterH[2] = 30;
}
void Health::draw_health(N5110 &lcd,SHIP shipUsed)
{
    // Draw shield and sealth bars based on ship
    switch (shipUsed) {
        case kestrel:
            lcd.drawSprite(81,2,45,3,(int *)kestrel_h);
            lcd.drawLine(82,45,82,46 - (_ship_health * _health_unit),FILL_BLACK);
            break;
        case imperion:
            lcd.drawSprite(81,2,45,3,(int *)imperion_h);
            lcd.drawLine(82,45,82,46 - (_ship_health * _health_unit),FILL_BLACK);
            break;
        case orion:
            lcd.drawSprite(81,2,45,3,(int *)orion_h);
            lcd.drawLine(82,45,82,46 - (_ship_health * _health_unit),FILL_BLACK);
            break;
    }

}
void Health::draw_shields(N5110 &lcd)
{
    // draw the sheields as a line next to the health bar
    lcd.drawRect(79,2,1,_ship_shields,FILL_BLACK);
}
void Health::update(int bars,Gamepad &pad)
{
    // only take damage in shields if shields are up
    if(_ship_shields > 0) {
        _ship_shields = _ship_shields - (bars * 10);
        // dont let ship shields drop below zero
        if(_ship_shields < 0) {
            _ship_shields = 0;
            pad.tone(100,0.1); // add noise to indicate if shields are brocken
            wait(0.1);
        }
    } else {
        // once shields are down start losing health
        _ship_health = _ship_health - bars;
        if(_ship_health < 0) {
            _ship_health = 0;
        }
    }
}
void Health::seekerh_update(int seno,int dmg)
{
    // seno determines what seeker took damage
    switch (seno) {
        case 1:
            _seekerH[0] = _seekerH[0] - dmg;
            break;
        case 2:
            _seekerH[1] = _seekerH[1] - dmg;
            break;
        case 3:
            _seekerH[2] = _seekerH[2] - dmg;
            break;
    }
    // dont let seeker health fall below zero
    if(_seekerH[0] < 0) {
        _seekerH[0] = 0;
    }
    if(_seekerH[1] < 0) {
        _seekerH[1] = 0;
    }
    if(_seekerH[2] < 0) {
        _seekerH[2] = 0;
    }
}
void Health::shooterh_update(int shno, int dmg)
{
    // shno determines what shooter took damage
    switch (shno) {
        case 1:
            _shooterH[0] = _shooterH[0] - dmg;
            break;
        case 2:
            _shooterH[1] = _shooterH[1] - dmg;
            break;
        case 3:
            _shooterH[2] = _shooterH[2] - dmg;;
            break;
    }
    // dont let shooter health fall below zero
    if(_shooterH[0] < 0) {
        _shooterH[0] = 0;
    }
    if(_shooterH[1] < 0) {
        _shooterH[1]= 0;
    }
    if(_shooterH[2] < 0) {
        _shooterH[2] = 0;
    }
}
Vector2D Health::get_hp()
{
    return{_ship_health, _ship_shields};
}
int Health::get_seekerh(int seno)
{
    // return appropriate health based on seeker number
    if(seno == 1) {
        return _seekerH[0];
    }
    if(seno == 2) {
        return _seekerH[1];
    }
    if(seno == 3) {
        return _seekerH[2];
    }
}
int Health::get_shooterh(int shno)
{
    // return appropriate health based on shooter number
    if(shno == 1) {
        return _shooterH[0];
    }
    if(shno == 2) {
        return _shooterH[1];
    }
    if(shno == 3) {
        return _shooterH[2];
    }
}
void Health::reset_seekerh(int seno)
{
    // reset any seeker health to default based on seeker number
    if(seno == 1) {
        _seekerH[0] = 10;
    }
    if(seno == 2) {
        _seekerH[1] = 10;
    }
    if(seno == 3) {
        _seekerH[2] = 10;
    }
}
void Health::reset_shooterh(int shno)
{
    // reset any shooter health to default based on shooter number
    if(shno == 1) {
        _shooterH[0] = 30;
    }
    if(shno == 2) {
        _shooterH[1] = 30;
    }
    if(shno == 3) {
        _shooterH[2] = 30;
    }
}

