#ifndef Tool_H
#define Tool_H
#include "mbed.h"
#include "Global_my.h"
#include "N5110.h"
/** Tool Class 
* @brief  Useful tools include TNT and Timer 
* @author Yuyang Miao
* @date May, 2019  */
class Tool {
    public: 
    /** @brief TNT number decrease one and print TNT effect
    *@param x_axis of explosion point
    *@param y_axis of explosion point
    */
    void TNT_trig(N5110 &lcd, int x, int y);
    /** @brief Detect whether you press A to trigger TNT
    *@param x_axis of explosion point
    *@param y_axis of explosion point
    *@returns if return 1 TNT will explode
    */
    int TNT_detect(InterruptIn &A, Tool &Tool, N5110 &lcd, int x, int y);
    /** @brief Claculate time rmained
    *@param refresh ti
    */
    void timerc(float t);
    };
#endif