#ifndef Rotate_H
#define Rotate_H
#include "mbed.h"
#include "Image.h"
#include "Global_my.h"
#include "N5110.h"
#include "Tool.h"
#include <math.h>
#define PI 3.1415

class Image;

/** Rotate Class
* @brief can calculate coordinates and print graph so the hook can rotate
* @author Yuyang Miao
* @date May, 2019  */
class  Rotate
{
public:
    /** @brief the angle next time the hook will rotate to */
    float return_angle[3];
    /** @brief the flag which decides hook go clockwise or anticlockwise */
    int return_flag[3];
    /** @brief coordinates where the hook is at */
    float hookpoint[2];
    /** @brief Rotate stage for level 1, responsible for calculate coordinates and print graph
    *@param angle:the angle hook will be at
    *@param max:the maximum angle the hook will have
    *@param flag:decide the hook go clockwise or anticlockwise 
    */
    void rotate(N5110 &lcd, float angle, float max, int flag,  Tool & Tool, Rotate &Rotate, Image &Image);
    /** @brief Rotate stage for level 2, responsible for calculate coordinates and print graph
    *@param angle:the angle hook will be at
    *@param max:the maximum angle the hook will have
    *@param flag:decide the hook go clockwise or anticlockwise 
    */
    void rotate2(N5110 &lcd, float angle, float max, int flag,  Tool & Tool, Rotate &Rotate, Image &Image);
    /** @brief Rotate stage for level 3, responsible for calculate coordinates and print graph
    *@param angle:the angle hook will be at
    *@param max:the maximum angle the hook will have
    *@param flag:decide the hook go clockwise or anticlockwise 
    */
    void rotate3(N5110 &lcd, float angle, float max, int flag,  Tool & Tool, Rotate &Rotate, Image &Image);
};
#endif
