#include "Rotate.h"

// Rotate function can print one frame and calculate the angle for next time
void Rotate::rotate(N5110 &lcd, float angle, float max,  int flag,   Tool &Tool, Rotate &Rotate, Image &Image)
{
    //decide clockwise or anticlockwise
    if(angle == max) {//hook reaches the biggest angle
        Rotate.return_flag[0]=0;//when return_flag=0, the hook will rotate clockwise
    } else if(abs(angle)<0.1) {// hook reaches the smallest angle
        Rotate.return_flag[0]=1;//when return_flag=1, the hook will rotate anticlockwise
    };
    //printf("%d",flag);test the flag output
    switch( Rotate.return_flag[0]) {
        case 0 : {
            Rotate.return_angle[0]=angle - max/30;//hook rotate clockwise, the new angle is stored in the class variable return_angle.
            break;
        }
        case 1 : {
            Rotate.return_angle[0]=angle + max/30;//hook rotate anticlockwise, the new angle is stored in the class variable return_angle.
            break;
        }
    }
    Image.draw_object(42, 0, *Hook, lcd, Image, 0.05, Rotate, angle, 8, 6, 6);//draw_object function is in the Image class, this is function is used to draw graph.
     Tool.timerc(0.05);//timerc function is in  Tool class which is used to calculate the time remained
}

//The difference between rotate1 and rotate2 and rotate3 is that they use different draw_object function because they need to draw different maps.
void Rotate::rotate2(N5110 &lcd, float angle, float max,  int flag,   Tool &Tool, Rotate &Rotate, Image &Image)
{
    //decide which side
    if(angle == max) {
        Rotate.return_flag[1]=0;
    } else if(abs(angle)<0.1) {
        Rotate.return_flag[1]=1;
    };
    //printf("%d",flag);
    switch( Rotate.return_flag[1]) {
        case 0 : {
            Rotate.return_angle[1]=angle - max/30;
            break;
        }
        case 1 : {
            Rotate.return_angle[1]=angle + max/30;
            break;
        }
    }
    Image.draw_object_2(42, 0, *Hook, lcd, Image, 0.05, Rotate, angle, 8, 6, 6);
     Tool.timerc(0.05);
}

//The difference between rotate1 and rotate2 and rotate3 is that they use different draw_object function because they need to draw different maps.
void Rotate::rotate3(N5110 &lcd, float angle, float max,  int flag,   Tool &Tool, Rotate &Rotate, Image &Image)
{
    //decide which side
    if(angle == max) {
        Rotate.return_flag[2]=0;
    } else if(abs(angle)<0.1) {
        Rotate.return_flag[2]=1;
    };
    //printf("%d",flag);
    switch( Rotate.return_flag[2]) {
        case 0 : {
            Rotate.return_angle[2]=angle - max/30;
            break;
        }
        case 1 : {
            Rotate.return_angle[2]=angle + max/30;
            break;
        }
    }
    Image.draw_object_3(42, 0, *Hook, lcd, Image, 0.05, Rotate, angle, 8, 6, 6);
     Tool.timerc(0.05);
}