#ifndef Release_H
#define Release_H
#include "mbed.h"
#include "Image.h"
#include "Global_my.h"
#include "Rotate.h"
#include "Detect.h"
#include "Pull.h"
#include "Tool.h"
#include <math.h>



/** Release Class
* @brief responsible for the duration between release hook and the hook come back
* @author Yuyang Miao
* @date May, 2019  */
class Release
{
public:
    /** @brief Release stage for level 1, responsible for release and pull back the hook
    *@param angle: which angle the hook are aming at when release the hook
    */
    void release(Pull &Pull, Detect &detect,  N5110 &lcd, Image &Image, float angle, InterruptIn &A, Tool &Tool, Rotate &Rotate);
    /** @brief Release stage for level 2, responsible for release and pull back the hook
    *@param angle: which angle the hook are aming at when release the hook
    */
    void release_2(Pull &Pull, Detect &detect,  N5110 &lcd, Image &Image, float angle, InterruptIn &A, Tool &Tool, Rotate &Rotate);
    /** @brief Release stage for level 3, responsible for release and pull back the hook
    *@param angle: which angle the hook are aming at when release the hook
    */
    void release_3(Pull &Pull, Detect &detect,  N5110 &lcd, Image &Image, float angle, InterruptIn &A, Tool &Tool, Rotate &Rotate);
};
#endif