#include "Release.h"
/*
The idea behind  Release:

                                                                                                             yes
Level_1------------------->Release------------->detect(if the hook attach anything, in detect class)--------------------->draw_back(draw back gold or rock, in draw class),then break from release function.
                                                                                                                 |
                                                                                                                 |No, hook keeps moving, and if distance greater than threshold
                                                                                                                 |
                                                                                                            Hook comes back, and break from release function.
*/


void Release::release(Pull &Pull, Detect &detect, N5110 &lcd, Image &Image, float angle, InterruptIn &A,  Tool &Tool, Rotate &Rotate)
{
    float distance_detect = 0;//initial value of how far the hook will move.
    while(1) {
        Image.draw_object(Rotate.hookpoint[0], Rotate.hookpoint[1], *Hook, lcd, Image, 0.1, Rotate, angle, 4, 6, 6);//draw_object  function is in Image class and able to draw everything in the scree.
        Tool.timerc(0.1);//calculate remaining time
        distance_detect = distance_detect+1;//distance plus one
        if(detect.detect(Pull, lcd, Image, angle,distance_detect, A, Tool, Rotate)==1) {
            break;//if the hook has hooked something, the detect function will call drawback function and draw back gold or rock. Then detect return 1, we break out from release function.
        }
        if( distance_detect>12) {//if variable distance_detect reaches 12 and the hook haven't reach any thing, the hook will come back.
            while(distance_detect>0) {
                Image.draw_object(Rotate.hookpoint[0], Rotate.hookpoint[1], *Hook, lcd, Image, 0.1, Rotate, angle, -4, 6, 6);
                distance_detect= distance_detect-1;
                Tool.timerc(0.1);
            }
            break;
        }
    }
}

//the difference between release_2 and release_3 is that the use draw_object_2/draw_object_3 and detect_2/detect_3 due to different maps and rock/gold coordination.

void Release::release_2(Pull &Pull, Detect &detect, N5110 &lcd, Image &Image, float angle, InterruptIn &A, Tool &Tool, Rotate &Rotate)
{
    float distance_detect = 0;
    while(1) {
        Image.draw_object_2(Rotate.hookpoint[0], Rotate.hookpoint[1], *Hook, lcd, Image, 0.1, Rotate, angle, 4, 6, 6);
        Tool.timerc(0.1);
        distance_detect = distance_detect + 1;
        if(detect.detect_2(Pull, lcd, Image, angle, distance_detect, A, Tool, Rotate)==1) {
            break;
        }
        if( distance_detect>12) {
            while(distance_detect>0) {
                Image.draw_object_2(Rotate.hookpoint[0], Rotate.hookpoint[1], *Hook, lcd, Image, 0.1, Rotate, angle, -4, 6, 6);
                distance_detect= distance_detect-1;
                Tool.timerc(0.1);
            }
            break;
        }
    }
}

void Release::release_3(Pull &Pull, Detect &detect, N5110 &lcd, Image &Image, float angle, InterruptIn &A, Tool &Tool, Rotate &Rotate)
{
    float distance_detect = 0;
    while(1) {
        Image.draw_object_3(Rotate.hookpoint[0], Rotate.hookpoint[1], *Hook, lcd, Image, 0.1, Rotate, angle, 4, 6, 6);
        Tool.timerc(0.1);
        distance_detect = distance_detect + 1;
        if(detect.detect_3(Pull, lcd, Image, angle, distance_detect, A, Tool, Rotate)==1) {
            break;
        }
        if( distance_detect>12) {
            while(distance_detect>0) {
                Image.draw_object_3(Rotate.hookpoint[0], Rotate.hookpoint[1], *Hook, lcd, Image, 0.1, Rotate,  angle, -4, 6, 6);
                distance_detect= distance_detect-1;
                Tool.timerc(0.1);
            }
            break;
        }
    }
}
