#ifndef Pull_H
#define Pull_H
#include "mbed.h"
#include "N5110.h"
#include "Image.h"
#include "Tool.h"
#include "Rotate.h"
#include "Global_my.h"
#include <math.h>

/** Pull Class
* @brief responsible for pull back the hook if we have hooked a Golg/Rock
* @author Yuyang Miao
* @date May, 2019  */
class Pull{
    public: 
    /** @brief Pull back stage for level 1, determine what we hooked and pull back the hook with it.
    *@param ii: index which we can use to determine what we hooked.
    *@param distance_detect: tell us how far he hook has released so we know how far we should go back
    *@param angle: the angle the hook at
    */
    void pull_back(N5110 &lcd, Image &Image, int ii, float distance_detect, float angle, InterruptIn &A, Tool &Tool, Rotate &Rotate);
     /** @brief Pull back stage for level 2, determine what we hooked and pull back the hook with it.
    *@param ii: index which we can use to determine what we hooked.
    *@param distance_detect: tell us how far he hook has released so we know how far we should go back
    *@param angle: the angle the hook at
    */
    void pull_back_2(N5110 &lcd, Image &Image, int ii, float distance_detect, float angle, InterruptIn &A, Tool &Tool, Rotate &Rotate);
    /** @brief Pull back stage for level 3, determine what we hooked and pull back the hook with it.
    *@param ii: index which we can use to determine what we hooked.
    *@param distance_detect: tell us how far he hook has released so we know how far we should go back
    *@param angle: the angle the hook at
    */
    void pull_back_3(N5110 &lcd, Image &Image, int ii, float distance_detect, float angle, InterruptIn &A, Tool &Tool, Rotate &Rotate);
    };
    
 #endif   