#ifndef logistic_H
#define logistic_H
#include "mbed.h"
#include "N5110.h"
#include "Menu.h"
#include "Gamepad.h"
#include "Level.h"
#include "Global_my.h"

class Level;

/** logistic Class
* @brief provide winning logic to decide we win or lose
* @author Yuyang Miao
* @date May, 2019  */
class logistic
{
public :
    /** @brief winning logic for the first stage*/
    int log_1(N5110 &lcd, logistic &logistic, Level &Level);
    /** @brief winning logic for the Second stage*/
    int log_2(N5110 &lcd, logistic &logistic, Level &Level);
    /** @brief winning logic for the Third stage*/
    int log_3(N5110 &lcd, logistic &logistic, Gamepad &Gamepad, Menu &Menu, Level &Level);
private:
    /** @brief reset all the coordinates*/
    void RE_initial();
    /** @brief when you lose this function print "you failed" and take you to the beginning*/
    void Go_back(N5110 &lcd, Level &Level, logistic &logistic);
};

#endif