#ifndef Level_H
#define Level_H
#include "mbed.h"
#include "Image.h"
#include "Rotate.h"
#include "Release.h"
#include "Global_my.h"
#include "Gamepad.h"
#include "Pull.h"
#include "Menu.h"
#include "logistic.h"
#include "Tool.h"

class logistic;

/** Level Class
* @brief 3 levels of game
* @author Yuyang Miao
* @date May, 2019  */
class Level
{
public:
    /** @brief flag related with start*/
    int g_Start_flag;
    /** @brief flag related with back*/
    int g_Back_flag;
    /** @brief flag related with B*/
    int g_B_flag;
    /** @brief detector decide which stage we switch to inside level*/
    int detector;
    /** @brief responsible for all the stage and perfomence in level 1*/
    void level_1(Menu &Menu, Image &Image, N5110 &lcd, Rotate &Rotate, Release &Release, Detect &Detect, Pull &Pull, InterruptIn &Start, InterruptIn &B, InterruptIn &Back,
                 InterruptIn &A, Gamepad &Gamepad, logistic &logistic, Level &Level, Tool &Tool);
    /** @brief responsible for all the stage and perfomence in level 2*/
    void level_2(Image &Image, N5110 &lcd, Rotate &Rotate, Release &Release, Detect &Detect, Pull &Pull, InterruptIn &A,
                 InterruptIn &B, logistic &logistic, Level &Level, Tool &Tool);
     /** @brief responsible for all the stage and perfomence in level 3*/
    void level_3(Image &Image, N5110 &lcd, Rotate &Rotate, Release &Release, Detect &Detect,  Pull &Pull, Gamepad &Gamepad, InterruptIn &A,
                 InterruptIn &B, logistic &logistic, Level &Level, Menu &Menu, Tool &Tool);
     /** @brief Press button and get flag to determine which stage we are going to in level 1 */
    int Get_flag(InterruptIn &Start, InterruptIn &B, InterruptIn &Back, InterruptIn &A, Level &Level);
    /** @brief Press button and get flag to determine which stage we are going to in level 2/3 */
    int Get_flag_2_3(InterruptIn &B, InterruptIn &A, Level &Level);
};
#endif