#include "Level.h"

/*
    The idea behind  function level_1:


                                      case0: welcome Menu : draw one frame and re-enter function level_1 while loop. -----------------------------------------------------------------------------|
                                                                                                                                                                                                  |
                                      case1: Rotate: draw one frame , calculate the angle for next time and re-enter function level_1 while loop.-------------------------------------------------|
                                                                                                                                                                                                  |
    Switch--->                        case2: Release: once the B button is pushed, we go to Release function. Release function is a loop , once the required state is reached, break.---(break)---|
        |                                                                                                                                                                                         |
        |                             case3: Declaration Menu: draw one frame and re-enter function level_1 while loop.---------------------------------------------------------------------------|
    getflag()                                                                                                                                                                                     |
      ^                                                                                                     log_1 decided you can keep going or go to next level or you are failed             log_1----> level 2
      |                                                                                                                                                                                           |     |
      |                                                                                                                                                                                           |     |
      |                                                                                                                                                                                           |     Fail
      ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

eg.     when you enter the game, nothing is being pushed so no flags and variable "detector" is 0, so inside the while(1) loop,
        every time you will go to case 0. Everytime you will print one frame, so it becomes a consistent Menu.


level_2 and level_3 have the same ideas as level_1, instead drawing different maps, using different release functions and don't have welcome and declaration menu.

*/


void Level::level_1(Menu &Menu, Image &Image, N5110 &lcd, Rotate &Rotate, Release &Release, Detect &Detect, Pull &Pull, InterruptIn &Start,
                    InterruptIn &B, InterruptIn &Back, InterruptIn &A,   Gamepad &Gamepad, logistic &logistic, Level &Level, Tool &Tool)
{
    while(1) {
        //gets flag which can tell which case we are going to.
        Level.detector=Level.Get_flag(Start, B, Back, A, Level);
        switch(detector) {
            case 0 : {
                //case 0 is welcome menu
                Menu.Welcome(lcd, Gamepad);
                break;
            }
            case 1 : {//after case 3, you enter the rotate case which is designed to calculate and print. So we can have our hook rotating at the top of screen waiting to be released.
                Rotate.rotate(lcd, Rotate.return_angle[0], PI, Rotate.return_flag[0],  Tool, Rotate, Image);
                //printf("f%", Rotate.return_angle); This function can detect whether the rotationg function is working.
                break;
            }
            case 2 : {// if you press B button, you can break from the rotating case and release hook. Then hook comes back, you wil break from release state and went into switch again.
                Release.release(Pull, Detect, lcd,Image, Rotate.return_angle[0], A, Tool, Rotate);
                //printf("f%", Rotate.return_angle);
                g_B_flag = 0;
                g_Back_flag = 1;//go to rotate stage
                break;
            }
            //once you press start at welcome menu, you will go to stage 3 which tell you, how to play this game. you can press back to skip
            case 3 : {
                Menu.Declaration(lcd, Gamepad);
                break;
            }
        }
        //when the hook is back, this function will judge by the time remained and your score to decide whether you keep looping or go to next level or confirmed as fail ang directly go back to the welcome menu.
        if(logistic.log_1(lcd, logistic, Level)==1) {
            break;
        }
    }
}

// This is similiar to level 1 without welcome and declaration menu
void Level::level_2(Image &Image, N5110 &lcd, Rotate &Rotate, Release &Release, Detect &Detect, Pull &Pull,
                    InterruptIn &A, InterruptIn &B,   logistic &logistic, Level &Level ,Tool &Tool)
{
    while(1) {
        //The difference from "Level.Get_flag_2_3()" is that this function doesn't detect Start and Back button.
        Level.detector=Level.Get_flag_2_3( B, A, Level);
        switch(detector) {
            case 1 : {
                //rotate2 function is specially designed for level 2 because it draws the second map
                Rotate.rotate2(lcd, Rotate.return_angle[1], PI, Rotate.return_flag[1],  Tool, Rotate, Image);
                //printf("f%", Rotate.return_angle); can be used to test the function.
                break;
            }
            case 2 : { //release2 function is specially designed for level 2 because it draws the second map
                Release.release_2(Pull, Detect, lcd,Image, Rotate.return_angle[1], A, Tool, Rotate);
                //printf("f%", Rotate.return_angle);
                break;
            }
        }
        // designed winning logic for second level
        if(logistic.log_2(lcd, logistic, Level)==1) {
            break;
        }
    }
}
// level 3 is very similar to level 2 instead of substituding "rotate2", "release_2" "log_2" with  "rotate3", "release_3" "log_3"
void Level::level_3(Image &Image, N5110 &lcd, Rotate &Rotate, Release &Release, Detect &Detect, Pull &Pull, Gamepad &Gamepad,
                    InterruptIn &A, InterruptIn &B,   logistic &logistic, Level &Level, Menu &Menu, Tool &Tool)
{
    while(1) {
        Level.detector=Level.Get_flag_2_3( B, A, Level);
        switch(detector) {
            case 1 : {
                Rotate.rotate3(lcd, Rotate.return_angle[2], PI, Rotate.return_flag[2],  Tool, Rotate, Image);
                //printf("f%", Rotate.return_angle);
                break;
            }
            case 2 : {
                Release.release_3(Pull, Detect, lcd,Image, Rotate.return_angle[2], A, Tool, Rotate);
                //printf("f%", Rotate.return_angle);
                break;
            }
        }

        if(logistic.log_3(lcd, logistic, Gamepad, Menu, Level)==1) {
            break;
        }
    }
}
// this is function is used to detec the activity of buttons amd return flag for level 1 so we can decide which case we are switching to
int Level::Get_flag(InterruptIn &Start, InterruptIn &B, InterruptIn &Back, InterruptIn &A, Level &Level)
{
    Level.detector=Start.read();//when nothing is pressed, detector=0, go to case 0(Welcome Menu)
    if(Start.read()) {//whether start is pressed
        Level.g_Start_flag=1;
    }

    if(Back.read()) {//whether back is pressed
        Level.g_Back_flag=1;
    }

    if(B.read()) {//whether B is pressed
        Level.g_B_flag=1;
    }

    if(Level.g_Start_flag) {//If start is pressed, go to case 3(declaration menu)
        detector=3;
    }

    if(Level.g_Back_flag) {//If Back is pressed, go to case 1(Rotate state)
        Level.g_Start_flag=0;
        detector=1;
    }
    if(Level.g_B_flag) {//If B is pressed, go to case 2(Release hook)
        Level.g_Back_flag=0;
        detector=2;
    }
    return detector;
}
// this function is used to get flags for level 2 and level 3, both dont have start and back button.
int Level::Get_flag_2_3(InterruptIn &B, InterruptIn &A, Level &Level)
{
    Level.detector=1;
    if(B.read()) {
        Level.g_B_flag=1;
    }
    if(Level.g_B_flag) {
        Level.g_B_flag=0;
        detector=2;
    } else {
        detector=1;
    }
    return detector;
}