#ifndef Image_H
#define Image_H
#include "mbed.h"
#include "N5110.h"
#include "Rotate.h"
#include "Global_my.h"
#include <math.h>

class Rotate;

/** Image Class
* @brief responsible for all the drawing on the screen
* @author Yuyang Miao
* @date May, 2019  */
class Image
{
public:
    /** @brief draw objects in level 1
    *@param x_axis: drawing point
    *@param y_axis: drawing point
    *@param graph: what we are drawing , Hook, Golad or Rock
    *@param time: wait time after refresh
    *@param angle: which angle we are going, so we can decide our next hook point
    *@param speed: how fast the Hook/Gold/Rock is moving
    *@param sizex: describe the square we draw graph in.
    *@param sizey: describe the square we draw graph in.
    */
    void draw_object(int x, int y, const int *graph, N5110 &lcd, Image &Image, float time, Rotate &Rotate, float angle, float speed, int sizex, int sizey);
    /** @brief draw objects in level 2
    *@param x_axis: drawing point
    *@param y_axis: drawing point
    *@param graph: what we are drawing , Hook, Golad or Rock
    *@param time: wait time after refresh
    *@param angle: which angle we are going, so we can decide our next hook point
    *@param speed: how fast the Hook/Gold/Rock is moving
    *@param sizex: describe the square we draw graph in.
    *@param sizey: describe the square we draw graph in.
    */
    void draw_object_2(int x, int y, const int *graph, N5110 &lcd, Image &Image, float time, Rotate &Rotate, float angle, float speed, int sizex, int sizey);
    /** @brief draw objects in level 3
    *@param x_axis: drawing point
    *@param y_axis: drawing point
    *@param graph: what we are drawing , Hook, Golad or Rock
    *@param time: wait time after refresh
    *@param angle: which angle we are going, so we can decide our next hook point
    *@param speed: how fast the Hook/Gold/Rock is moving
    *@param sizex: describe the square we draw graph in.
    *@param sizey: describe the square we draw graph in.
    */
    void draw_object_3(int x, int y, const int *graph, N5110 &lcd, Image &Image, float time, Rotate &Rotate, float angle, float speed, int sizex, int sizey);
private:
    /** @brief draw UI include Score, Goal, TNT number, Time remain*/
    void print_UI(N5110 &lcd);
    /** @brief draw level 1 map*/
    void draw_map_1(N5110 &lcd);
    /** @brief draw level 2 map*/
    void draw_map_2(N5110 &lcd);
    /** @brief draw level 3 map*/
    void draw_map_3(N5110 &lcd);
};


#endif