#ifndef Detect_H
#define Detect_H
#include "mbed.h"
#include "Global_my.h"
#include "Image.h"
#include "Pull.h"
#include "Tool.h"
#include <math.h>
#define PI 3.1415

/** Detect Class
* @brief detect whether we hook a Gold/Rock or not
* @author Yuyang Miao
* @date May, 2019  */
class Detect
{
public:
    /** @brief judge that whether the hook hook a Gold/Rock or not in level 1
    *@param angle:the angle hook  at
    *@param distance_detect: tell us how far he hook has released so we know how far we should go back
    *@returns return 1 if we have hooked something and pulled it back, so we can break out from release stage. Else retun0
    */
    int detect(Pull &Pull, N5110 &lcd, Image &Image, float angle, float distance_detect,InterruptIn &A, Tool &Tool, Rotate &Rotate);
     /** @brief judge that whether the hook hook a Gold/Rock or not in level 2
    *@param angle:the angle hook  at
    *@param distance_detect: tell us how far he hook has released so we know how far we should go back
    *@returns return 1 if we have hooked something and pulled it back, so we can break out from release stage. Else retun0
    */
    int detect_2(Pull &Pull, N5110 &lcd, Image &Image, float angle, float distance_detect,InterruptIn &A, Tool &Tool, Rotate &Rotate);
     /** @brief judge that whether the hook hook a Gold/Rock or not in level 3
    *@param angle:the angle hook  at
    *@param distance_detect: tell us how far he hook has released so we know how far we should go back
    *@returns return 1 if we have hooked something and pulled it back, so we can break out from release stage. Else retun0
    */
    int detect_3(Pull &Pull, N5110 &lcd, Image &Image, float angle, float distance_detect,InterruptIn &A, Tool &Tool, Rotate &Rotate);
};
#endif