#include"Detect.h"

/*
The idea behind  Detect:

    Due to the size of the screen, it will be too hard if we only say that the hook has hooked an object when the hook touches the object.
    Instead we can draw a circle at hook point and another one at the centre of Gold/Rock. when this two circles are tangent with each other
    we consider the hook has hooked a Gold/Rock. The radius for two circles are both 3.5.

    After confirmation that the hook has hooked a Gold/Rock, the hookpoint will be assigned the value of the centre point
    and we use function pull_back()(within Pull class) to draw a line between (42,0) and pull back the Gold/Rock.

    level_1_x, level_1_y : Coordinates for gold/rock in level 1. Random coordinates will mess up with the difficulty of game.
    level_1_X, level_1_Y : centre point for gold/rock which we will draw a circle with.
    
    !They are global variables stored in "Global_my"

    This is same for level 2 and level 3.
*/


int Detect::detect(Pull &Pull, N5110 &lcd, Image &Image, float angle, float distance_detect, InterruptIn &A, Tool &Tool, Rotate &Rotate)
{
    for(int i=0; i<7; i=i+1) {//The number of rock and gold in level 1 altogether is 7.
        float distance = lcd.calDistance(Rotate.hookpoint[0],Rotate.hookpoint[1],level_1_X[i],level_1_Y[i]);//calculate the distance between hookpoint and thecentre point.
        if (distance < 7) {//if distance<7 which means two circles are tangent with each other.
            float cos_value=(42-level_1_X[i])/lcd.calDistance(level_1_X[i],level_1_Y[i],42,0);//find out the cos value between the centre point and (42,0)
            Rotate.hookpoint[0]= level_1_X[i],//let the hookpoint equals to the centre point
                                 Rotate.hookpoint[1]= level_1_Y[i],
                                         level_1_x[i]=100;//set the centre point and coordinates out of range so the Gold/Rock will not be drawed nor detected.
            level_1_y[i]=100;
            level_1_X[i]=100;
            level_1_Y[i]=100;
            angle = acos(cos_value);//use arccos function to calculate the angle bwtween the centre point and (42,0)
            //printf("%f\n",angle);are used to test the angle
            Pull.pull_back(lcd, Image, i, distance_detect, angle, A, Tool, Rotate);//pass the angle to pull_back function.
            return 1;//if we detect a Gold/Rock and pull it back, we can return 1 so Release function before will break so we can go back to rotate stage again.
        } else {
            continue;
        }
    }
    return 0;//if nothing is detected, the hook will keep going until it reached maximum length
}


// detect_2 and detect_3 use another set of coordinates and center point, draw different maps.
int Detect::detect_2(Pull &Pull, N5110 &lcd, Image &Image, float angle, float distance_detect, InterruptIn &A, Tool &Tool, Rotate &Rotate)
{
    for(int i=0; i<10; i=i+1) {
        float distance = lcd.calDistance(Rotate.hookpoint[0],Rotate.hookpoint[1],level_2_X[i],level_2_Y[i]);
        if (distance < 7) {
            float cos_value=(42-level_2_X[i])/lcd.calDistance(level_2_X[i],level_2_Y[i],42,0);
            Rotate.hookpoint[0]= level_2_X[i],
                                 Rotate.hookpoint[1]= level_2_Y[i],
                                         level_2_x[i]=100;
            level_2_y[i]=100;
            level_2_X[i]=100;
            level_2_Y[i]=100;
            angle = acos(cos_value);
            Pull.pull_back_2(lcd, Image, i, distance_detect, angle, A, Tool, Rotate);
            return 1;
        } else {
            continue;
        }
    }
    return 0;
}



int Detect::detect_3(Pull &Pull, N5110 &lcd, Image &Image, float angle, float distance_detect, InterruptIn &A, Tool &Tool, Rotate &Rotate)
{
    for(int i=0; i<12; i=i+1) {
        float distance = lcd.calDistance(Rotate.hookpoint[0],Rotate.hookpoint[1],level_3_X[i],level_3_Y[i]);
        if (distance < 7) {
            float cos_value=(42-level_3_X[i])/lcd.calDistance(level_3_X[i],level_3_Y[i],42,0);
            Rotate.hookpoint[0]= level_3_X[i],
                                 Rotate.hookpoint[1]= level_3_Y[i],
                                         level_3_x[i]=100;
            level_3_y[i]=100;
            level_3_X[i]=100;
            level_3_Y[i]=100;
            angle = acos(cos_value);
            Pull.pull_back_3(lcd, Image, i, distance_detect, angle, A, Tool, Rotate);
            return 1;
        } else {
            continue;
        }
    }
    return 0;
}