#ifndef SNAKE_H
#define SNAKE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Snake Class
 * @brief The class for drawing snake and determining snake position for snake game
 * @author Daniel Crockford 201039580
 * @date 09 May 2019
 */
class Snake {
    
public:
    /** Constructor */
    Snake();
    
    /** Deconstructor */
    ~Snake();

    /** initialise snake */
    void init();
    
    /** draw the snake head
    * @param N5110 class for controlling the lcd screen */
    void draw_head(N5110 &lcd);
    
    /** allows snake horizontal position to be set from outside
    * @param value between 0 and 80 */
    void set_snake_posX(int snake_posX);
    
    /** allows snake vertical position to be set from outside
    * @param value between 0 and 44 */
    void set_snake_posY(int snake_posY);
    
    /** get snake horizontal position */
    int get_snake_posX();
    
    /** get snake vertical position*/
    int get_snake_posY();
    
    /** draw food
    * @param N5110 class for controlling the lcd screen*/ 
    void draw_food(N5110 &lcd);
    
    /** allows food horizontal position to be set from outside
    * @param value between 4 and 80 */
    void set_food_posX(int food_posX);
    
    /** allows food vertical position to be set from outside
    * @param value between 4 and 40 */
    void set_food_posY(int food_posY);
    
    /** get snake food horizontal position */
    int get_food_posX();
    
    /** get food vertical position */ 
    int get_food_posY();

private:
    int _snake_posX;
    int _snake_posY;
    int _food_posX;
    int _food_posY;
};
#endif

