#include "Game_engine.h"
#include "Snake.h"

// constructor and destructor empty
GameEngine::GameEngine() {
}
GameEngine::~GameEngine() {
}

// Instance
Snake snake;

void GameEngine::direction_reset() {
    _direction = 0; // resets direction so menu can be selected using buttons
}

void GameEngine::init() {
    snake.init(); // initialize snake
    _game_cont = true;
    snake.set_food_posX((rand()%(19) + 1) * 4); // randomize horizontal food position
    snake.set_food_posY((rand()%(11) + 1) * 4 - 2); // randomize vertical food position
    _body_seg = 1;
    _direction = 0;
    _score = 0;
}

void GameEngine::draw(N5110 &lcd) {    
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT); // Draws screen limits
    snake.draw_head(lcd); // call head drawing
    snake.draw_food(lcd); // call food drawing
}

void GameEngine::get_dir(Gamepad &gamepad) {
    if ( gamepad.check_event(Gamepad::Y_PRESSED) && _direction != 1) { // if Y button pressed go up unless snake is going down
        _direction = 0;
    }
    else if ( gamepad.check_event(Gamepad::A_PRESSED) && _direction != 0) { // if A button pressed go down unless snake is going up
        _direction = 1;
    }
    else if ( gamepad.check_event(Gamepad::X_PRESSED) && _direction != 3) { // if X button pressed go left unless snake is going right
        _direction = 2;
    }
    else if ( gamepad.check_event(Gamepad::B_PRESSED) && _direction != 2) { // if B button pressed go right unless snake is going left
        _direction = 3;
    }
}

void GameEngine::snake_move() { // checks direction of snake and increments snake in direction of travel
    if (_direction == 0) {
        snake.set_snake_posY (snake.get_snake_posY()- 4);    
    } else if (_direction == 1) {
        snake.set_snake_posY (snake.get_snake_posY()+ 4);   
    } else if (_direction == 2) {
        snake.set_snake_posX (snake.get_snake_posX()- 4); 
    } else if (_direction == 3) {
        snake.set_snake_posX (snake.get_snake_posX()+ 4); 
    }
}

void GameEngine::food_move() {
    srand(time(NULL));
    _food_reset = true;
    if(snake.get_snake_posX() == snake.get_food_posX() && snake.get_snake_posY() == snake.get_food_posY()) { // if snake head and food position in same place then reset food
        snake.set_food_posX((rand()%(19) + 1) * 4);
        snake.set_food_posY((rand()%(11) + 1) * 4 - 2);
        while(_food_reset == true) { // loop until food reset flag is not triggered
            _food_reset = false;
            for (int k = _body_seg; k > 0; k--) {
                if((_body_posX[k] == snake.get_food_posX() && _body_posY[k] == snake.get_food_posY()) || (snake.get_snake_posX() == snake.get_food_posX() && snake.get_snake_posY() == snake.get_food_posY())) {
                        // if food position is the same as any of the snake body segments then reset food
                    snake.set_food_posX((rand()%(19) + 1) * 4);
                    snake.set_food_posY((rand()%(11) + 1) * 4 - 2); 
                    _food_reset = true;  
                }
            } 
        }
        _body_seg = _body_seg + 1; // increment number of body segments
        _score = _score + 1; // increment score
    }    
}

void GameEngine::snake_body(N5110 &lcd) {
    _body_posX[0] = snake.get_snake_posX();
    _body_posY[0] = snake.get_snake_posY();
    for (int j = _body_seg; j > 0; j--) {
        lcd.drawRect(_body_posX[j],_body_posY[j],4,4,FILL_BLACK); // draw each body part
        _body_posX[j] = _body_posX[j-1];
        _body_posY[j] = _body_posY[j-1];   
    }
}

void GameEngine::check_wall_collision() {
    if (snake.get_snake_posX() < 4 || snake.get_snake_posX() > 80 || snake.get_snake_posY() < 0 || snake.get_snake_posY() > 44) { // check if snake head has hit any of the walls
        _game_cont = false;
    }    
}

void GameEngine::check_snake_collision() {
    for (int i = _body_seg; i > 1; i--) {
        if (_body_posX[i] == snake.get_snake_posX() && _body_posY[i] == snake.get_snake_posY()) { // if snake head matches any part of snake body collision has occurred
            _game_cont = false; 
        }   
    }
}

// accessors
// this method gets the boolean value for checking whether the game should be running
bool GameEngine::get_game_cont() {
    return _game_cont;    
}

// this method gets the direction set by the gamepad
int GameEngine::get_direction() {
    return _direction;    
}

// this method gets the score
int GameEngine::get_score() {
    return _score;    
}
