/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds

Name: DANIEL CROCKFORD
Username: el16dlc
Student ID Number: 201039580
Date: 07/05/2019
*/


#include "main.h"
#include "Snake.h"
#include "Game_engine.h"

// Gamepad Peripherals
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);

Gamepad gamepad;

// Instances
GameEngine engine;

bool game_cont = false;
float speed = 0.0;
int game_speed = 0;
//int score = 0;


int main() {
    Init(); 
    Welcome();
    while(1) {
        engine.direction_reset();
        Menu();
        engine.init();
    
        while(engine.get_game_cont() == true) {
            render();
            update();
        }
        game_over();
    }
}


// Initialise gamepad
void Init() {
    lcd.init();
    gamepad.init();
    lcd.setContrast(0.5);
    lcd.setBrightness(0.5);
    gamepad.leds_off();
    gamepad.check_event(Gamepad::A_PRESSED);
    gamepad.check_event(Gamepad::B_PRESSED);
    gamepad.check_event(Gamepad::X_PRESSED);
    gamepad.check_event(Gamepad::Y_PRESSED);
    gamepad.check_event(Gamepad::L_PRESSED);
    gamepad.check_event(Gamepad::R_PRESSED);
    gamepad.check_event(Gamepad::BACK_PRESSED);
    gamepad.check_event(Gamepad::START_PRESSED); 
}

// Prototype welcome screen
void Welcome() {
    lcd.clear();
    lcd.printString("ELEC2645",0,0);
    lcd.printString("PROJECT",0,1);
    lcd.printString("201039580",0,2);
    lcd.refresh();
    wait(2.0);
}

// Protoype menu
void Menu() {  
    game_speed = 0;
    lcd.clear();
    lcd.printString("Select speed",0,0);
    lcd.printString("Slowest: X",0,2);
    lcd.printString("Fastest: B",0,3);
    lcd.refresh(); 
    while(game_speed == 0) {
        engine.get_dir(gamepad);
        if (engine.get_direction() == 2) {
            game_speed = 1;
        } else if (engine.get_direction() == 3) {
            game_speed = 2;    
        }
    }
    if (game_speed == 1) {
        speed = 0.5;    
    } else if (game_speed == 2) {
        speed = 0.2;
    }
}

// Draws each frame on screen
void render() {
    lcd.clear();
    engine.draw(lcd);
    lcd.refresh();
}
void update() {
    engine.check_wall_collision();
    engine.check_snake_collision();
    engine.get_dir(gamepad);
    engine.snake_move();
    engine.food_move();
    engine.snake_body(lcd);
    lcd.refresh();
    wait(speed);
}

void game_over() {
    int score = engine.get_score();
    score = score * game_speed;
    lcd.clear();
    lcd.printString("Your score is:",0,0);
    char buffer[14];
    sprintf(buffer,"%2d",score);
    lcd.printString(buffer,0,1);
    lcd.refresh();
    wait(2.0);    
}