#ifndef GAME_ENGINE_H
#define GAME_ENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "main.h"
#include "Gamepad.h"
#include "Game_engine.h"
#include "Snake.h"


/** GameEngine Class
 * @brief The game engine for snake game
 * @author Daniel Crockford 201039580
 * @date 09 May 2019
 */
class GameEngine {

public:
    /** Constructor */
    GameEngine();
    
    /** DeConstructor */
    ~GameEngine();
    
    /** resets direction */
    void direction_reset();
    
    /** initialises engine */
    void init();
    
    /** draws all objects
    * @param N5110 class for controlling lcd screen */
    void draw(N5110 &lcd);
    
    /** get directions from gamepad
    * param Gamepad class for accessing gamepad controls */
    void get_dir(Gamepad &gamepad);
    
    /** moves snake */
    void snake_move();
    
    /** moves food */
    void food_move();
    
    /** draws snake body
    * @param N5110 class for controlling lcd screen*/
    void snake_body(N5110 &lcd);
    
    /** checks for collisions with wall and creates flag */
    void check_wall_collision();
    
    /** checks for collision with snake body and creates flag */
    void check_snake_collision();
    
    /** get game continue flag */ 
    bool get_game_cont();
    
    /** get direction value */
    int get_direction();
    
    /** get score */
    int get_score();
    
private:
    int _direction;
    int _body_posX[100];
    int _body_posY[100];
    int _body_seg;
    bool _game_cont;
    bool _food_reset;
    int _score;
};

#endif