/* Tank.cpp
Produces a tank object
and dictates it's movement
1.4.19
*/
#include "Tank.h"

Tank::Tank()
{
  _speed = 1;
}

Tank::~Tank()
{

}
// Accessors
int Tank::get_position_x()
{
  return _position_x;
}

int Tank::get_position_y()
{
  return _position_y;
}

int Tank::get_hitbox(int i)
{
  return _hitbox[i];
}

int Tank::get_health()
{
  return _health;
}
// Mutators
void Tank::set_position(int x, int y)
{
  _position_x = x;
  _position_y = y;
}    

void Tank::set_movement_limits(int left, int right)     // Determines the boundaries within which
{                                                       // a tank can move. Prevents it from leaving the 
  _left_lim = left;                                     // screen or moving through the central obstacle.
  _right_lim = right;   
}

void Tank::set_speed(int s)
{
  _speed = s;   
}

void Tank::set_health(int h)
{
  _health = h;   
}

// Other Methods
void Tank::move_position(int d)                // Governs how the tank moves in the horizontal
{                                              // x direction. The speed in which it moves is related
  int slowness = 9 - _speed;                   // to framerate (wait_ms(1000/60), therefore in order to 
  int i = _move_counter % slowness;            // slow its movement it cannot move on every frame.
  if (d > 0) {
    _move_counter++;                           // Movement counter increases if right button is pressed.
    if (i == 0 && _position_x < _right_lim) {  // i reaches zero every (slowness)number of cycles of the game loop 
      _position_x++;                           // provided the tanks is not at a limit it will move when i reaches zero.
    }
  } else if (d < 0) {      
    _move_counter--;                           // Movement counter decreases if left button is pressed.
    if (i == 0 && _position_x > _left_lim) {
      _position_x--;
    }
  }
}

void Tank::lose_health()
{
  _health--;
}

void Tank::generate_hitbox()                                      // Generates a hitbox based on the x and y position of the 
{                                                                 // tank's bottom left pixel. The screen is a cartesian plane
  int i = 0;                                                      // with the bottom left of the screen representing the origin.
  for (int i0 = 0; i0 < 4; i0++) {                                // Every pixel on the screen has a coreesponding integer value
    for (int i1 = 1; i1 < 11; i1++) {                             // assigned to it: the pixel at (0,0) being 1 and the pixel 
      _hitbox[i] = (i0 + _position_y) * 84 + _position_x + i1;    // (83,47) being 4032. A tank's hitbox is 10 pixels wide and
      i++;                                                        // 4 pixels high. The tank's hitbox is described by all the pixels
    }                                                             // in this 10x4 area inserted into an array.
  }
}