#ifndef SCORES_H
#define SCORES_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Menus Class
* @brief Calculates, ranks and displays the players' scores.
* @author Maxim C. Delacoe
* @date April 2019
*/

class Scores
{
    
public:
  // Constructor and destructor.
  /**
  * @brief Constructor 
  * @details Sets the highscores to 0.
  */     
  Scores();
  /**
  * @brief Destructor 
  * @details Non user specified.
  */
  ~Scores();
  // Member Methods
  /**
  * @brief Calculate's the winner's score based on number of turns played and initial health.
  * @param turns @details The number of turns the game has elapsed
  * @param health @details The initial health of the tanks
  */  
  float score_calculator(int turns, int health); 
  /**
  * @brief Displays the winner's score on the screen.
  * @param current @details The concluding score for the current game
  * @param lcd @details The lcd object from N5110 class.
  */ 
  void display_score(float current, N5110 &lcd);
  /**
  * @brief Displays the highest three score on the screen.
  * @param lcd @details The lcd object from N5110 class.
  */ 
  void display_top_scores(N5110 &lcd);
    
private:

  void _add_to_top_scores(float new_score);

  float _top_three[3];
};

#endif // SCORES_H
