/* Scores.cpp
Processes new scores and saves 
the highest ones.
23.4.19
*/
#include "Scores.h"

Scores::Scores()
{
  _top_three[0] = 0;
  _top_three[1] = 0;
  _top_three[2] = 0;
}

Scores::~Scores()
{

}

float Scores::score_calculator(int turns, int health) // Calculates score
{
  float new_score = health * 100 / turns;
  _add_to_top_scores(new_score);
  return new_score;
}

void Scores::display_score(float current, N5110 &lcd)  // Display the current games end score
{
  char buffer[14]; 
  sprintf(buffer, "%.0f", current); 
  lcd.printString(" Score :", 10, 4); 
  lcd.printString(buffer, 60, 4);
}  

void Scores::display_top_scores(N5110 &lcd) // Displays high scores 
{
  char buffer[14]; 
  sprintf(buffer, "%.0f", _top_three[0]); 
  lcd.printString(" 1. ", 15, 2); 
  lcd.printString(buffer, 45, 2);
    
  sprintf(buffer, "%.0f", _top_three[1]); 
  lcd.printString(" 2. ", 15, 3); 
  lcd.printString(buffer, 45, 3);
    
  sprintf(buffer, "%.0f", _top_three[2]); 
  lcd.printString(" 3. ", 15, 4); 
  lcd.printString(buffer, 45, 4);
}     

void Scores::_add_to_top_scores(float new_score) // Ranks the top scores in descending 
{                                                // order in an array
  if (new_score > _top_three[0]) { 
    _top_three[2] = _top_three[1];
    _top_three[1] = _top_three[0];
    _top_three[0] = new_score; 
  } else if (new_score > _top_three[1]) {
    _top_three[2] = _top_three[1];
    _top_three[1] = new_score; 
  } else if (new_score > _top_three[2]) { 
    _top_three[2] = new_score; 
  }    
}   
