/* Projectile.cpp
Produces a projectile on the lcd
and dictates it's movement
9.4.19
*/
#include "Projectile.h"
#define DEG2PI 0.0174532925

Projectile::Projectile()
{

}

Projectile::~Projectile()
{

}
// Accessors
int Projectile::get_position_x()
{
  return _position_x;
}

int Projectile::get_position_y()
{
  return _position_y;
}

int Projectile::get_hitbox(int i)
{
  return _hitbox[i];
}
// Mutators
void Projectile::set_launch_parameters(int x, int y, float ang, float vel,  // set the initial parameters of 
                                       float grav, float wind)              // the projectile's flight.
{
  _time = 0;
  _init_x = x;
  _init_y = y;
  _lnch_ang = ang;
  _init_vel = vel;
  _grav_acc = grav;
  _wind_acc = wind;
}
// Other Methods
void Projectile::generate_hitbox()                                 // Generates a hitbox based on the x and y position of the  
{                                                                  // projectiles's bottom left pixel. The screen is a cartesian plane
  int i = 0;                                                       // with the bottom left of the screen representing the origin.
  for (int i0 = 0; i0 < 2; i0++) {                                 // Every pixel on the screen has a coreesponding integer value
    for (int i1 = 1; i1 < 3; i1++) {                               // assigned to it: the pixel at (0,0) being 1 and the pixel 
      _hitbox[i] = (i0 + _position_y) * 84 + _position_x + i1;     // (83,47) being 4032. The projectiles's hitbox is 10 pixels wide and
      i++;                                                         // 4 pixels high. The projectiles's hitbox is described by all the pixels
    }                                                              // in this 2x2 area inserted into an array.
  }
}

void Projectile::update_flight()                                               // The flight of the projectile is modelled on the equations
{                                                                              // for the displacement of an object during projectile motion.
  _position_x = _init_x + _init_vel * _time * cos(_lnch_ang * DEG2PI) - 0.5 *  // The projectile moves across the lcd by updating the time 
                _wind_acc * _time * _time;                                     // component on every iteration of the game loop.
  _position_y = _init_y + _init_vel * _time * sin(_lnch_ang * DEG2PI) - 0.5 * 
                _grav_acc * _time * _time;
  _time += 0.5;
}

bool Projectile::check_boundaries()                                    // If the projectile leaves the lcd from the left, right or 
{                                                                      // bottom of the screen then the projectile phase should end.
  if (_position_x < -3 || _position_x > 87  || _position_y < -3) {
    return true;
  } else { 
    return false;
  }
}
