#ifndef MENUS_H
#define MENUS_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Graphics.h"
#include "Scores.h"

/** Menus Class
* @brief Generates and navigates the outside-of-game menus.
* @author Maxim C. Delacoe
* @date April 2019
*/

class Menus
{
    
public:
  // Constructor and destructor.
  /**
  * @brief Constructor 
  * @details Sets the settings to default.
  */     
  Menus();
  /**
  * @brief Destructor 
  * @details Non user specified.
  */
  ~Menus();
  
  //Accessors
  /**
  * @brief Gets the player's preference for the mute setting.
  * @returns mute on or off
  */  
  bool get_mute();
  /**
  * @brief Gets the player's preference for the tank's initial health.
  * @returns tank's initial health
  */  
  int get_health();
  
  //Member Methods
  /**
  * @brief Shows the start up visuals and awaits player's input.
  * @param &graphics * @details The graphics object from Graphics class.
  * @param &lcd * @details The lcd object from N5110 class.
  * @param &pad * @details The pad object from Gamepad class.
  */  
  void start_up_screen(Graphics &graphics, N5110 &lcd, Gamepad &pad);
  /**
  * @brief Navigates the menu screens and awaits player's input.
  * @param &graphics * @details The graphics object from Graphics class.
  * @param &lcd * @details The lcd object from N5110 class.
  * @param &pad * @details The pad object from Gamepad class.
  * @param &scores * @details The scores object from Scores class.
  */  
  void main_menu(Graphics &graphics, N5110 &lcd, Gamepad &pad, Scores &scores);
    
private:
    
  void _start_up_visuals(Graphics &graphics, N5110 &lcd, Gamepad &pad);
  void _main_menu_controls(N5110 &lcd, Gamepad &pad, Scores &scores);
  void _read_inputs(Gamepad &pad);
  void _controls_screen(N5110 &lcd, Gamepad &pad);
  void _settings_screen(N5110 &lcd, Gamepad &pad);
  void _mute_brightness_lives(N5110 &lcd, Gamepad &pad);
  void _scores_screen(N5110 &lcd, Gamepad &pad, Scores &scores);
    
  int _counter;
  int _health;
  bool _mute;
  float _brightness;
  float _contrast;
};

#endif // MENUS_H