/* Menus.cpp
Governs all the Menus
and outside-of-game articles.
13.4.19
*/
#include "Menus.h"

Menus::Menus()
{
  _health = 6;
  _mute = false;
  _contrast = 0.4;
}

Menus::~Menus()
{

}

void Menus::start_up_screen(Graphics &graphics, N5110 &lcd, Gamepad &pad)
{
  while(pad.check_event(Gamepad::START_PRESSED) == false) {
    _read_inputs(pad);
    lcd.clear();
    graphics.draw_start_up_screen(lcd);
    lcd.printString("  Press Start ",0,3);
    _start_up_visuals(graphics, lcd, pad);
    lcd.drawRect(0, 0, 84 , 48, FILL_TRANSPARENT);
    lcd.drawRect(1, 1, 82 , 46, FILL_TRANSPARENT);
    lcd.refresh();  
  }
}

void Menus::main_menu(Graphics &graphics, N5110 &lcd, Gamepad &pad,
                      Scores &scores)
{
  while(pad.check_event(Gamepad::Y_PRESSED) == false) {
    pad.leds_off();
    lcd.clear();
    _main_menu_controls(lcd, pad, scores);
    lcd.printString(" (Y) Play",0,1);  
    lcd.printString(" (X) Controls",0,2);         
    lcd.printString(" (A) Settings",0,3);
    lcd.printString(" (B) Scores",0,4);
    lcd.drawRect(0, 0, 84 , 48, FILL_TRANSPARENT);
    lcd.drawRect(1, 1, 82 , 46, FILL_TRANSPARENT);
    lcd.refresh();  
    wait_ms(1000/60); 
  }
}

void Menus::_main_menu_controls(N5110 &lcd, Gamepad &pad, Scores &scores)   
{
  pad.check_event(Gamepad::BACK_PRESSED);
  if (pad.check_event(Gamepad::X_PRESSED) == true) { 
    _controls_screen(lcd, pad); 
  }
  else if (pad.check_event(Gamepad::A_PRESSED) == true) { 
    _settings_screen(lcd, pad); 
  }
  else if (pad.check_event(Gamepad::B_PRESSED) == true) { 
    _scores_screen(lcd, pad, scores); 
  }
}

void Menus::_start_up_visuals(Graphics &graphics, N5110 &lcd, Gamepad &pad) // Draw start up visuals
{
  if (_counter >= 0) {
    graphics.start_up(1, pad);
    graphics.draw_tank_l(10, 5, lcd);
    graphics.draw_turret_l(10, 5, 10, lcd);
    graphics.draw_tank_r(64, 5, lcd);
    graphics.draw_turret_r(64, 5, 180, lcd);
  } else {
    graphics.start_up(0, pad);
    graphics.draw_tank_l(10, 5, lcd);
    graphics.draw_turret_l(10, 5, 180, lcd);
    graphics.draw_tank_r(64, 5, lcd);
    graphics.draw_turret_r(64, 5, 340, lcd);
  }
  if (_counter >= 199) { 
    _counter = -200; 
  }
  _counter++;
}

void Menus::_read_inputs(Gamepad &pad)   // Clear the triggers
{
  pad.check_event(Gamepad::Y_PRESSED);
  pad.check_event(Gamepad::X_PRESSED);
  pad.check_event(Gamepad::A_PRESSED);
  pad.check_event(Gamepad::B_PRESSED);
}

void Menus::_controls_screen(N5110 &lcd, Gamepad &pad)
{
  while(pad.check_event(Gamepad::BACK_PRESSED) == false) {     
    _read_inputs(pad);
    lcd.clear();
    lcd.printString(" Stick: Aim",0,1);  
    lcd.printString(" A    : Fire",0,2);         
    lcd.printString(" L/R  : Move",0,3);
    lcd.printString(" Pot  : Power",0,4);
    lcd.drawRect(0, 0, 84 , 48, FILL_TRANSPARENT);
    lcd.drawRect(1, 1, 82 , 46, FILL_TRANSPARENT);
    lcd.refresh(); 
    wait_ms(1000/60);  
  }
}

void Menus::_settings_screen(N5110 &lcd, Gamepad &pad)
{
  while(pad.check_event(Gamepad::BACK_PRESSED) == false) {     
    lcd.clear();
    _mute_brightness_lives(lcd, pad);
    _read_inputs(pad);
    lcd.printString("(O) Health:",4,1);  
    lcd.printString("(A) Mute:",4,2);  
    lcd.printString("(B) Brightness",4,3); 
    lcd.printString("tune with pot",4,4);   
    lcd.drawRect(0, 0, 84 , 48, FILL_TRANSPARENT);
    lcd.drawRect(1, 1, 82 , 46, FILL_TRANSPARENT);
    if (_mute == true ) { 
      lcd.drawRect(70, 17, 7 , 7, FILL_BLACK); 
    } else { 
      lcd.drawRect(70, 17, 7 , 7, FILL_TRANSPARENT); 
    } 
    lcd.refresh(); 
    wait_ms(1000/60);  
  }
}

void Menus::_mute_brightness_lives(N5110 &lcd, Gamepad &pad)
{
  _counter--;
  if (_counter < 0) {  // counter stops multiple consecutive button clicks
    _counter = 10;
    if (pad.get_direction() == W && _health > 1) { 
      _health-- ; 
    } else if (pad.get_direction() == E && _health < 6) { 
      _health++ ; 
    } else if (pad.check_event(Gamepad::A_PRESSED) == true) { 
      _mute = !_mute; 
    } else if (pad.check_event(Gamepad::B_PRESSED) == true) {
      lcd.setBrightness(pad.read_pot()); 
    } else { 
      _counter = -1; //reset counter
    }        
  }
  char buffer[14]; 
  sprintf(buffer,"%d",_health);  
  lcd.printString(buffer, 74, 1);
}

void Menus::_scores_screen(N5110 &lcd, Gamepad &pad, Scores &scores)
{
  while(pad.check_event(Gamepad::BACK_PRESSED) == false) {   
    lcd.clear();
    scores.display_top_scores(lcd);
    lcd.printString("High Scores", 10, 1);
    lcd.drawRect(0, 0, 84 , 48, FILL_TRANSPARENT);
    lcd.drawRect(1, 1, 82 , 46, FILL_TRANSPARENT);
    _read_inputs(pad);
    lcd.refresh(); 
    wait_ms(1000/60);  
  }  
}

bool Menus::get_mute()
{
  return _mute;   
}

int Menus::get_health()
{
  return _health;   
}