#ifndef STONE_H
#define STONE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Stone class
 *     
 * @brief Class for listing the parameter of Stone and its characteristics
 * 
 * @version 0.56
 * 
 * @author Siuting Wong 201186503
 * 
 * @date 8th May 2019
 * 
 * @code
 * 
 * /////////////// structs /////////////////
 * struct UserInput {
 *     Direction d;
 *     float mag;
 *     Vector2D mapped_coord;
 * };
 * /////////////// objects ///////////////
 * N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
 * Gamepad pad;
 * Engine eng;
 * 
 * ///////////// prototypes ///////////////
 * void init();
 * void update_game(UserInput input);
 * void render();
 * void welcome();
 * void endgame();
 * void introduction();
 * void fingersnap();
 * 
 * ///////////// Images ///////////////
 * const int Avenger0[25][32] = {
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0 },
 *     { 0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,1,1,0,1,1,1,1,1,0,0,0,0,0,1,0,0,0 },
 *     { 0,0,0,1,0,0,0,0,0,1,1,1,0,0,0,1,1,0,1,1,1,0,1,1,0,0,0,0,1,0,0,0 },
 *     { 0,0,0,1,0,0,0,0,0,1,1,0,0,0,1,1,1,0,1,1,1,0,1,1,0,0,0,0,1,0,0,0 },
 *     { 0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,0,1,1,1,0,0,0,1,0,0,0 },
 *     { 0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0,0,0 },
 *     { 0,0,0,1,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,0,0,1,0,0,0 },
 *     { 0,0,1,1,1,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,0,0,0,1,1,0,1,1,1,0,0 },
 *     { 0,0,1,1,1,0,1,1,0,0,0,1,1,1,0,0,0,1,0,1,1,0,0,0,1,1,0,1,1,1,0,0 },
 *     { 0,0,0,1,0,0,1,1,0,0,0,1,1,1,1,1,1,1,1,0,1,0,0,0,1,1,0,0,1,0,0,0 },
 *     { 0,0,0,0,0,0,1,1,1,0,1,1,1,0,0,0,0,1,0,1,1,0,0,1,1,1,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,1,1,1,0,1,1,1,0,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,1,1,0,0,0,0,0,0,0,0 },
 *     { 0,0,0,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0 },
 *     { 0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,0,0,0 },
 *     { 0,0,0,1,0,0,0,1,1,1,0,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,0,0,0 },
 *     { 0,0,0,1,0,0,0,1,1,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
 * };
 * 
 * const int Avenger1[25][32] = {
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0 },
 *     { 0,0,0,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,0,0,0 },
 *     { 0,0,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,1,1,1,1,1,0,0,0,0,1,1,1,0,0 },
 *     { 0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,1,1,0,1,1,1,0,1,1,0,0,0,1,1,1,0,0 },
 *     { 0,0,0,1,0,0,0,0,0,1,1,0,0,0,1,1,1,0,1,1,1,0,1,1,0,0,0,0,1,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,0,1,1,1,0,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,0,0,0,0,0,0 },
 *     { 0,0,0,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,0,0,0,1,1,0,0,1,0,0,0 },
 *     { 0,0,0,1,0,0,1,1,0,0,0,1,1,1,0,0,0,1,0,1,1,0,0,0,1,1,0,0,1,0,0,0 },
 *     { 0,0,0,1,0,0,1,1,0,0,0,1,1,1,1,1,1,1,1,0,1,0,0,0,1,1,0,0,1,0,0,0 },
 *     { 0,0,0,1,0,0,1,1,1,0,1,1,1,0,0,0,0,1,0,1,1,0,0,1,1,1,0,0,1,0,0,0 },
 *     { 0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,1,1,1,0,1,1,1,0,0,0,0,0,0,0 },
 *     { 0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,1,1,0,0,0,0,1,0,0,0 },
 *     { 0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,1,0,0 },
 *     { 0,0,1,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,1,0,0 },
 *     { 0,0,0,1,0,0,0,1,1,1,0,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,0,0,0 },
 *     { 0,0,0,0,0,0,0,1,1,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
 * };
 * 
 * const int intro0[8][84] = {
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0 },
 *     { 0,0,0,1,0,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0 },
 *     { 0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,0,0 },
 *     { 0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,0,0 },
 *     { 0,0,0,1,0,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0 },
 *     { 0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
 * };
 * const int intro1[8][84] = {
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
 * };
 * const int intro2[8][84] = {
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
 * };
 * 
 * const int intro3[16][18] = {
 *     { 0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0 },
 *     { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0 },
 *     { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0 },
 *     { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
 *     { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
 *     { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0 },
 *     { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0 },
 *     { 0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0 },
 * };
 * 
 * ///////////// functions ////////////////
 * int main() {
 *     while (1) {
 *         int fps = 6;
 *         
 *         init();     // initialise and then display welcome screen...
 *         welcome();
 *         introduction(); // The intro of the story
 *         render();
 *         wait(1.0f/fps);  // and wait for one frame period
 *     
 *         while (1) {
 *             eng.read_input(pad);
 *             eng.update(pad);
 *             render();
 *             wait(1.0f/fps);
 *             if (eng.get_score() < 3) { // setting diffculty regarding the current stone number
 *                 fps = 6;
 *             }
 *             if (eng.get_score() == 3) {
 *                 fps = 9;
 *             }
 *             if (eng.get_score() == 4) {
 *                 fps = 12;
 *             }
 *             if (eng.get_score() == 5) {
 *                 fps = 15;
 *             }
 *             if (eng.get_score() == 6) { // you win!!
 *                 fingersnap();
 *                 break;
 *             } else if (eng.get_score() < 0) { // you lose :(
 *                 endgame();
 *                 break;
 *             }
 *         }
 *     }
 * }
 * 
 * void init() {
 *     // need to initialise LCD and Gamepad 
 *     lcd.init();
 *     pad.init();
 *      
 *     // initialise the game with correct ball and paddle sizes
 *     eng.init(WALL_WIDTH,WALL_GAP,STONE_SIZE,SPEED);
 * }
 * 
 * void welcome() {
 *     lcd.clear();
 *     lcd.printString("Eternity Stone",0,0); //play messages
 *     lcd.printString("Start story",9,4);
 *     lcd.drawSprite(25,8,25,32,(int *)Avenger0);
 *     lcd.refresh();
 *     pad.tone(440.00,0.21); // adding avenger music
 *     wait(0.21);
 *     pad.tone(587.3,0.63);
 *     wait(0.63);
 *     pad.tone(0.0,0.06);
 *     wait(0.06);
 *     pad.tone(587.3,0.63);
 *     wait(0.63);
 *     pad.tone(0.0,0.06);
 *     wait(0.06);
 *     pad.tone(587.3,0.63);
 *     wait(0.63);
 *     pad.tone(0.0,0.06);
 *     wait(0.06);
 *     pad.tone(587.3,0.42);
 *     wait(0.42);
 *     pad.tone(880.0,0.21);
 *     wait(0.21);
 *     pad.tone(784.0,1.40);
 *     wait(1.40);
 *     pad.tone(698.5,0.70);
 *     wait(0.70);
 *     pad.tone(659.3,0.70);
 *     wait(0.70);
 *     pad.tone(587.3,0.63);
 *     wait(0.70);
 *     while (pad.check_event(Gamepad::START_PRESSED) == false) { // animation loop until start button is pressed
 *         lcd.clear();
 *         lcd.printString("Eternity Stone",0,0);
 *         lcd.printString("Start story",9,4);
 *         lcd.drawSprite(25,8,25,32,(int *)Avenger0);
 *         lcd.refresh();
 *         wait(0.5);
 *         lcd.clear();
 *         lcd.printString("Eternity Stone",0,0);
 *         lcd.printString("Start story",9,4);
 *         lcd.drawSprite(25,8,25,32,(int *)Avenger1);
 *         lcd.refresh();
 *         wait(0.5);
 *     }
 * }
 * 
 * void introduction() { // background story
 *     lcd.clear();
 *     lcd.printString("Five years",12,0);
 *     lcd.refresh();
 *     wait(1.0);
 *     lcd.printString("Since Thanos",6,2);
 *     lcd.printString("destroyed half",0,3);
 *     lcd.printString("of all life",9,4);
 *     lcd.printString("on Earth",18,5);
 *     lcd.refresh();
 *     wait(1.0);
 *     lcd.printString("(Press start)",3,1);
 *     wait(1.0);
 *     while (pad.check_event(Gamepad::START_PRESSED) == false) { // while-looping until the button is on
 *         lcd.refresh();
 *         wait(0.5);
 *     }
 *     
 *     lcd.clear(); // background story
 *     lcd.printString("You are a",12,0);
 *     lcd.printString("member of",15,1);
 *     lcd.printString("Avengers and",6,2);
 *     lcd.printString("you need to",9,3);
 *     lcd.printString("time travel in",0,4);
 *     lcd.printString("Quantum realm",3,5);
 *     lcd.refresh();
 *     wait(1.0);
 *     while ( pad.check_event(Gamepad::START_PRESSED) == false) { // while-looping until the button is on
 *         lcd.refresh();
 *         wait(0.5);
 *     }
 *     
 *     while (pad.check_event(Gamepad::START_PRESSED) == false) { // tutorial with animation
 *         lcd.clear();
 *         lcd.printString("Use your",18,0);
 *         lcd.printString("joystick to",9,1);
 *         lcd.printString("send yourself",3,2);
 *         lcd.printString("to the right",6,3);
 *         lcd.printString("Wormhole",18,4);
 *         lcd.drawSprite(0,40,8,84,(int *)intro0);
 *         lcd.refresh();
 *         wait(0.5);
 *         lcd.clear();
 *         lcd.printString("Use your",18,0);
 *         lcd.printString("joystick to",9,1);
 *         lcd.printString("send yourself",3,2);
 *         lcd.printString("to the right",6,3);
 *         lcd.printString("Wormhole",18,4);
 *         lcd.drawSprite(0,40,8,84,(int *)intro1);
 *         lcd.refresh();
 *         wait(0.5);
 *         lcd.clear();
 *         lcd.printString("Use your",18,0);
 *         lcd.printString("joystick to",9,1);
 *         lcd.printString("send yourself",3,2);
 *         lcd.printString("to the right",6,3);
 *         lcd.printString("Wormhole",18,4);
 *         lcd.drawSprite(0,40,8,84,(int *)intro2);
 *         lcd.refresh();
 *         wait(0.5);
 *     }
 *     
 *     while (pad.check_event(Gamepad::START_PRESSED) == false) { // tutorial with animation
 *         lcd.clear();
 *         lcd.printString("try not to",12,0);
 *         lcd.printString("interrupt",15,1);
 *         lcd.printString("the time",0,2);
 *         lcd.printString("line but",0,3);
 *         lcd.printString("pass thro.",12,4);
 *         lcd.printString("the gap",21,5);
 *         lcd.drawSprite(54,16,16,18,(int *)intro3);
 *         lcd.drawRect(77,0,2,18,FILL_BLACK);
 *         lcd.drawRect(77,30,2,18,FILL_BLACK);
 *         lcd.refresh();
 *         wait(0.5);
 *         lcd.clear();
 *         lcd.printString("try not to",12,0);
 *         lcd.printString("interrupt",15,1);
 *         lcd.printString("the time",0,2);
 *         lcd.printString("line but",0,3);
 *         lcd.printString("pass thro.",12,4);
 *         lcd.printString("the gap",21,5);
 *         lcd.drawSprite(60,16,16,18,(int *)intro3);
 *         lcd.drawRect(77,0,2,18,FILL_BLACK);
 *         lcd.drawRect(77,30,2,18,FILL_BLACK);
 *         lcd.refresh();
 *         wait(0.5);
 *     }
 *     
 *     lcd.clear(); // last message before the game begins
 *     lcd.printString("retrieve 6",12,0);
 *     lcd.printString("stones and",12,1);
 *     lcd.printString("win the game",6,2);
 *     lcd.printString("God speed",15,3);
 *     lcd.printString("Avengers!",15,4);
 *     lcd.refresh();
 *     wait(0.5);
 *     
 *     while (pad.check_event(Gamepad::START_PRESSED) == false) { //sparking leds
 *         pad.leds_on();
 *         wait(0.25);
 *         pad.leds_off();
 *         wait(0.25);
 *     }
 * }
 * 
 * void render() {
 *     // clear screen, re-draw and refresh
 *     lcd.clear();  
 *     eng.draw(lcd);
 *     lcd.refresh();
 * }
 * 
 * void fingersnap() {
 *     lcd.clear(); // at this point the game has broken the while loop, clear screen to display congrat message
 *     lcd.printString("Congrat!!",15,0);
 *     lcd.printString("Credit: STWong",0,1);
 *     lcd.printString("201186503",15,2);
 *     lcd.refresh();
 *     
 *     pad.tone(440.00,0.21); // avenger theme again
 *     wait(0.21);
 *     pad.tone(587.3,0.63);
 *     wait(0.63);
 *     pad.tone(0.0,0.06);
 *     wait(0.06);
 *     pad.tone(587.3,0.63);
 *     wait(0.63);
 *     pad.tone(0.0,0.06);
 *     wait(0.06);
 *     pad.tone(587.3,0.63);
 *     wait(0.63);
 *     pad.tone(0.0,0.06);
 *     wait(0.06);
 *     pad.tone(587.3,0.42);
 *     wait(0.42);
 *     pad.tone(880.0,0.21);
 *     wait(0.21);
 *     pad.tone(784.0,1.40);
 *     wait(1.40);
 *     pad.tone(698.5,0.70);
 *     wait(0.70);
 *     pad.tone(659.3,0.70);
 *     wait(0.70);
 *     pad.tone(587.3,0.63);
 *     wait(0.70);
 *     while (pad.check_event(Gamepad::START_PRESSED) == false) { // enter loop waiting to restart the game
 *         lcd.printString("press start",9,4);
 *         lcd.printString("to return",15,5);
 *         lcd.refresh();
 *         pad.leds_on();
 *         wait(0.5);
 *         pad.leds_off();
 *         wait(0.5);
 *     }
 * }
 * 
 * void endgame() {
 *     lcd.clear(); //break the while loop and enter gameover
 *     lcd.printString("Mr.Stark",18,1);
 *     lcd.printString("I don't feel",6,2);
 *     lcd.printString("so good ...",9,3);
 *     lcd.refresh();
 *     
 *     pad.tone(587.3,0.63); // play sad music when lose
 *     wait(0.63);
 *     pad.tone(0.0,0.06);
 *     wait(0.06);
 *     pad.tone(587.3,0.63);
 *     wait(0.63);
 *     pad.tone(0.0,0.06);
 *     wait(0.06);
 *     pad.tone(587.3,0.63);
 *     wait(0.63);
 *     pad.tone(0.0,0.06);
 *     wait(0.06);
 *     pad.tone(698.5,0.42);
 *     wait(0.42);
 *     pad.tone(659.3,0.21);
 *     wait(0.21);
 *     pad.tone(0.0,0.06);
 *     wait(0.06);
 *     pad.tone(659.3,0.42);
 *     wait(0.42);
 *     pad.tone(587.3,0.21);
 *     wait(0.21);
 *     pad.tone(0.0,0.06);
 *     wait(0.06);
 *     pad.tone(587.3,0.42);
 *     wait(0.42);
 *     pad.tone(554.4,0.21);
 *     wait(0.21);
 *     pad.tone(587.3,0.42);
 *     wait(0.42);
 *     while (pad.check_event(Gamepad::START_PRESSED) == false) { // enter loop waiting to restart the game
 *         lcd.printString("press start",9,4);
 *         lcd.printString("to return",15,5);
 *         lcd.refresh();
 *         wait(0.5);
 *     }
 * }
 * 
 * @endcode
 */

class Stone
{

public:
    Stone();
    ~Stone();
    /**
     * @brief Initiates the parameter of stone
     * @param x @details Vertical position of stone
     * @param size @details Size of stone
     * @param speed @details Speed of stone
     */
    void init(int x,int size,int speed);
    /**
     * @brief Displays stone on screen
     * @param N5110 @details LCD screen
     */
    void draw(N5110 &lcd);
    // accessors and mutators
    /** 
     * @brief Updates the position of stone
     * @returns The new coordinate of stone
     */
    void update();
    /** 
     * @brief Resets the position of stone
     * @returns The new coordinate of stone
     */
    void reset();
    /** 
     * @brief Retrieves the position of stone
     * @returns The coordinate of stone
     */
    Vector2D get_pos();
    
private:

    int _size; // the radius of the stone
    int _x;
    int _y;
    int _speed;
};
#endif