#include "Stone.h"

Stone::Stone()
{

}

Stone::~Stone()
{

}

void Stone::init(int x,int size,int speed) {
    _x = x; // stone x beginning postion and updating position
    _size = size; // wormhole's size
    int uncertainty = rand() % (48 - _size * 2);
    _y = _size + uncertainty; // starting random vertical position 
    _speed = speed; // sliding speed
}

void Stone::draw(N5110 &lcd) {
    lcd.drawCircle(_x,_y,_size,FILL_TRANSPARENT); // draw stone on lcd
}

void Stone::update() {
    _x -= _speed; // the stone is moving leftward from the right screen
}

void Stone::reset() {
    _x = 149; // replace to the right side when the stone exits to the left side of the screen
    int uncertainty = rand() % (45 - (_size * 2));
    _y = 1 + _size + uncertainty; // regenerate the vertical position for the stone
}

Vector2D Stone::get_pos() { // get position for collision logic function
    Vector2D p = {_x,_y};
    return p;
}