#include "Avenger.h"

// nothing doing in the constructor and destructor
Avenger::Avenger()
{

}

Avenger::~Avenger()
{

}

const int player0[6][11] = { // avenger image
    { 0,0,0,0,1,1,1,0,0,0,0 },
    { 0,1,0,0,0,0,1,1,0,1,0 },
    { 1,1,1,1,1,1,1,1,1,1,1 },
    { 1,1,1,1,1,1,1,1,1,1,1 },
    { 0,1,0,0,0,0,1,1,0,1,0 },
    { 0,0,0,0,1,1,1,0,0,0,0 },
};

const int easteregg[6][11] = { //easter egg ;)
    { 0,0,0,0,0,0,0,1,1,1,1 },
    { 1,0,0,0,0,0,0,1,1,1,1 },
    { 1,1,1,1,1,1,1,1,1,1,1 },
    { 1,1,1,1,1,1,1,1,1,1,1 },
    { 1,0,0,0,0,0,0,1,1,1,1 },
    { 0,0,0,0,0,0,0,1,1,1,1 },
};

void Avenger::init(int x) {
    
    _x = x;  // x value on screen is fixed
    _y = HEIGHT/2 - 3;  // y depends on height of screen and height of paddle
    _scale = 5; // scale determines how sensitive the joystick is
    _score = 1; // initiate the score
    _easter = rand() % 100;
}

void Avenger::draw(N5110 &lcd) {
    if (_easter < 5) { // there could be 5 percents playing as thor's hammer
        lcd.drawSprite(_x,_y,6,11,(int *)easteregg);
    } else {
        lcd.drawSprite(_x,_y,6,11,(int *)player0); // draw player0 on the screen
    }
}

void Avenger::update(Direction d,float mag,Vector2D mapped) {
    
    _y -= int(mapped.y * _scale);  // scale is arbitrary, could be changed in future

    // check the y origin to ensure that the paddle doesn't go off screen
    if (_y < 1) {
        _y = 1;
    }
    if (_y > HEIGHT - 7) {
        _y = HEIGHT - 7;
    }
}

void Avenger::add_score() { // add score when avenger retrieves the stone
    _score++;
}

void Avenger::lose_score() { // subtract the score when avenger collides with time-line
    _score--;
}

int Avenger::get_score() { // get score to turns on leds
    return _score;
}

Vector2D Avenger::get_pos() { // get position for collision logic
    Vector2D p = {_x,_y};
    return p;    
}
