#ifndef SNAKE_H
#define SNAKE_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"

/** Snake Class
* @brief Describes the methods and functions for the snake head
* @author Joshua R. Marshall
* @date Feb, 2018
*/

class Snake
{

public:

    Snake(); // constructor
    ~Snake(); // destructor
    
    /** Initialises the snakes direction and position when game starts 
    * @param Input direction from pad
    * @param Current direction of snake
    * @param pos_x x position
    * @param pos_y y position 
    */
    
    void init(Direction in, Direction cur, int pos_x, int pos_y);
    
    /** Updates methods for snake head
    * @param Input direction from pad
    * @param Current direction of snake
    */
    
    void update(Direction in, Direction cur);
    
    /** Draws snake head on lcd */
    
    void draw(N5110 &lcd);
    
    /** Gives the next direction of the snake
    * @brief Gives the next direction given the current and input directions
    * @param Input direction from pad
    * @param Current direction of snake
    */
    
    void set_snake_direction(Direction input, Direction current);
    
    /** Determines the possible next directions for the current direction CENTRE
    * @brief can be any direction except Centre
    * @param Input direction from pad
    * @param Current direction of snake
    */
    
    void set_centre(Direction input, Direction current);
    
    /** Determines the possible next directions for the current direction North
    * @brief Cannot be South
    * @param Input direction from pad
    * @param Current direction of snake
    */
    
    void set_north(Direction input, Direction current);
    
    /** Determines the possible next directions for the current direction East
    * @brief Cannot be West
    * @param Input direction from pad
    * @param Current direction of snake
    */
   
    void set_east(Direction input, Direction current);
  
    /** Determines the possible next directions for the current direction South
    * @brief Cannot be North
    * @param Input direction from pad
    * @param Current direction of snake
    */    
  
    void set_south(Direction input, Direction current);
  
    /** Determines the possible next directions for the current direction West
    * @brief Cannot be East
    * @param Input direction from pad
    * @param Current direction of snake
    */    
  
    void set_west(Direction input, Direction current);
    
    /** Gets snake direction
    * @return returns next direction of the snake head
    */
    
    Direction get_snake_direction();
    
    /** Sets the current direction such that it is never CENTRE
    * @param Input direction from pad
    */
    
    void set_current_direction(Direction input);
    
    /** Gets current direction
    * @return returns current direction
    */
    
    Direction get_current_direction();
    
    /** Given the next direction increments the snake's position appropriatley
    * @param Next direction from get_direction 
    */
    
    void set_snake_position(Direction next);
    
    /** Gets updated position
    * @return returns new position
    */
    
    Vector2D get_snake_position();
    
    

private:
    
    Direction _next;
    Direction _current;
    Direction _d;
    Vector2D _pos;
    
};
#endif