#ifndef FOOD_H
#define FOOD_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"

/** Frame_counting function */

int g_frame_counter(); //

static int g_fc; /**< int for frame counter */
    
/** Food Class
* @brief Describes the methods and functions for the food class
* @author Joshua R. Marshall
* @date Feb, 2018
*/

class Food
{

public:
    Food(); // constructor
    ~Food(); // destructor
    
    /** Initialise position of food */

    void init(bool collision);
    
    /** Updates food state  */

    void update(bool collision, int n_frames);
    
    /** Draws food on lcd */
    
    void draw(N5110 &lcd);
    
    /** Gets a random position for spawning food */
    
    Vector2D get_rand_pos();
    
    /** @brief resets food position when collsion event or a set number of frames have passed
    @param set_frames corresponds to frame counter
    @param number_frames number of frames before resetting food position
    @param when true reset food position
    */
    
    void set_food_position(int set_frames, int number_frames, bool collision);
    
    /** @return returns food position */
    
    Vector2D get_food_position();
    
private:

    int _x;
    int _y;
    int _number_frames;

};
#endif