#ifndef TESTS_H
#define TESTS_H

#include "Food-test.h"
#include "Snake-test.h"

/**
* @brief Runs tests on Food, Snake, and SnakeEngine classes
* @return Returns number of tests failed
*/


int run_tests()
{
    
    int tests_failed = 0; // number of failed tests
    
    // run food position tests
    
    printf("Running Food Positions Tests \n");
    
    bool food_test_passed = food_test_position();
    bool snake_test_passed = snake_test_movement();
    
    if(food_test_passed) {
        
        printf("FOOD TEST PASSED \n");
        
        }
        
        else {
            
            printf("FOOD TEST FAILED \n");
            
            ++tests_failed;
            
            }
    
    if(snake_test_passed) {
        
        printf("SNAKE TEST PASSED \n");
        
        }
        
        else {
            
            printf("SNAKE TEST FAILED \n");
            
            ++tests_failed;
            
            }
        
            
        
        
        // print how many tests failed or all passed
        
        if(tests_failed > 0) {
            
            printf("%i tests failed \n", tests_failed);
            
            }
            
            else {
                
                
                printf("All passed");
                
                }
                
        return tests_failed;
            
}
            
            
    


#endif