#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "SnakeEngine.h"



#define FOOD_X 20
#define FOOD_Y 20
#define SNAKE_P_X 42
#define SNAKE_P_Y 24
#define IN E
#define CUR E
#define SPAWN_TIME 200

#ifndef WITH_TESTING
#include "tests.h"
//#endif

struct UserInput 
{
    
    Direction d;
    
};


/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Joshua Robert Marshall
Username: ll13jrm
Student ID Number: 200764543
Date: 28/02/2018
*/

// ----- Objects -----

SnakeEngine snake_engine;
Gamepad pad;
Snake snake;
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
//Testing test1;

// ----- Prototypes -----

void init();
void update_game(UserInput input);
void render();
void start_screen();

int main() {
        
//#ifdef WITH_TESTING
    int number_of_failures = run_tests();

    if(number_of_failures > 0) return number_of_failures;
#endif
        init();
        start_screen();
        render();
        
        wait(0.2); 
              
        while(1) {
         
         
         snake_engine.get_input(pad);
         snake_engine.update(pad);
         render();

         wait(0.15); 
         
    }
    }
    
// initialies all classes and libraries
void init()
{
    // need to initialise LCD and Gamepad 
    lcd.init();
    pad.init();
     
    // initialise the game with food, snake...
    snake_engine.init(IN, CUR, SNAKE_P_X, SNAKE_P_Y, SPAWN_TIME);

}

// this function draws each frame on the LCD
void render()
{
    // clear screen, re-draw and refresh
    lcd.clear();
    snake_engine.draw(lcd);
    lcd.refresh();
    
}

void start_screen() 
{
    int i = 0;
    lcd.setContrast(0.5);
    for(i = 0; i <= 4; ++i) {
        
        lcd.printString("   NOTENDO    ", 0,i);
        lcd.refresh();
        wait(0.3);
        lcd.clear();        

        
        if(i == 4) {
            
            lcd.printString("   NOTENDO    ", 0,5);
            lcd.refresh();     
            pad.tone(0,1.75);
            wait(1.5);
            lcd.clear();
            
            }
        
        }
        
    while ( pad.check_event(Gamepad::START_PRESSED) == false ) {
        
        
        lcd.printString("   Welcome      ", 0, 1);
        lcd.printString(" Press Start    ", 0, 3);
        lcd.refresh();
        
        }
        
}