#ifndef SNAKEENGINE_H
#define SNAKEENGINE_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Food.h"
#include "Snake.h"


/** SnakeEngine Class
* @brief Class that initialises and defines the game charectoristics ready for the main file
* @author Joshua R. Marshall
* @date Feb, 2018
*/

static Vector2D g_tp;
void g_frame_time(int frame_time);


static int g_tl; // tail length
static int g_engine_fc; // frame counter for draw tail functions
static int g_ft; // frame counter for decreasing time between food spawning
static int g_n; // ensures spawning of food occurs periodically
static bool g_wall; // wall collision detected
    
/** Returns the speed 
*/
static double g_speed;

static int g_odd_array_x[100]; // array to store odd values for x component of tail segments
static int g_odd_array_y[100]; // array to store odd values for y component of tail segments
static int g_even_array_x[100]; // array to store even values for x component of tail segments
static int g_even_array_y[100]; // array to store even values for y component of tail segments
    
    
class SnakeEngine
{

public:

    SnakeEngine(); // constructor
    ~SnakeEngine(); // destructor
    
    
    /** Initialises the directions for the snake and the position for the food
    * @param Input direction from pad
    * @param Current direction of snake
    * @param pos_x x position
    * @param pos_y y position
    * @param sets initial number of frames between food spawning   
    */
    
    void init(Direction in, Direction cur, int pos_x, int pos_y, int n_frames); 
    
    /** Updates the Food and Snake classes from the Gamepad 
    */
    
    void update(Gamepad &pad);
    
    /** Draws the game to the lcd */
    
    void draw(N5110 &lcd);
    
    /** Draws the tail segments on the lcd */
    
    void draw_tail(N5110 &lcd);
        
    /** Gets the updated direction from the Gamepad and stores it in a struct 
    */
    
    void get_input(Gamepad &pad); 
    
    /** Check if snake has eaten food
    */
    
    bool detect_food_collision(Gamepad &pad);
    
    /** Checks if snake has hit wall 
    */
    bool detect_wall_collision(Gamepad &pad);
    
    /** Checks if snake has hit it's own tail
    */
    
    bool detect_tail_collision();
    
    /** Increments the length variable for tail when food is eaten
    * @param Checks if food and head have collided (been eaten)
    */
    
    void set_tail_length(bool collision_detected);
    
    /** Gets the updated length
    * @return returns the length of the tail
    */
    
    int get_tail_length();

    /** Creates an updated array of tail segments
    * @details When the engine_frame counter is odd it sets the odd_array,
               when the engine counter is even it sets the even_array.                 
    */
    
    void set_tail_array(Gamepad &pad);
    
    /** Updates the odd array with new positions
    * @details For the odd array it initially sets index 0 of even array to the 
               new position, then makes each odd index equal to the even 
               index -1 starting from the the bottom of the array finally adding
               the new position to index 0
    */

    void set_odd_array(Gamepad &pad);
    
    /** Updates the even array with new positions
    * @details For the even array it initially sets index 0 of odd array to the 
               new position, then makes each even index equal to the odd 
               index -1 starting from the the bottom of the array finally adding
               the new position to index 0
    */
    
    void set_even_array(Gamepad &pad);
    
    /** Decreses the amount of frames between spawning of food
    * @param determines the interval and amount of tail segments are reached
             before the time between spawning reduces   
    */
    
    int food_spawning_time(int frame_decrementer);
    
    /** Changes the frame rate increasing speed
    * @param determines much food is eaten before increasing the speed
    * @param defines the increase in speed
    */
    
    void increase_speed(int resetter, float speed_decrementer);

        
private:

    
    Food _food;

    Snake _snake;
    
    //Direction _snake_current_direction;
    int _snake_pos_x;
    int _snake_pos_y;
    
    Direction _in;
    Direction _cur;
    
    bool _collision;
    int _n_frames;
    
    int _tail_x;
    int _tail_y;
    
    int _number_food_frames;  
    void _wall_col_isr();
    

};
#endif