#include "Snake.h"

///////////////// constructor/destructor /////////////////

Snake::Snake()
{

}

Snake::~Snake()
{

}

///////////////// public methods /////////////////

void Snake::init(Direction in,Direction cur, int pos_x, int pos_y)
{
    
    _pos.x = pos_x;
    _pos.y = pos_y;
    set_snake_direction(in, cur);
    
}

void Snake::update(Direction in, Direction cur) 
{
    set_current_direction(in);
    cur = get_current_direction();
    set_snake_direction(in, cur);
    Direction next = get_snake_direction();
    set_snake_position(next);
    
}

void Snake::draw(N5110 &lcd)
{
    
    lcd.setPixel(_pos.x,_pos.y,true);
    
}

void Snake::set_snake_direction(Direction input, Direction current)
{
      
    switch(current) {
       
        case CENTRE:
        
                set_centre(input, current);
                
                break;
                
        case N:
        
                set_north(input, current);
                 
                break;
                
        case E:
        
                set_east(input, current);
                
                break;
                
        case S:
            
                set_south(input, current);
                
                break;
                
        case W:
        
                set_west(input, current);
                
                break;
                
        default:
                
                
                //set_centre(input, current);
                //error("Invalid state (current)");
                
                break;

            }
            
                                
}

Direction Snake::get_snake_direction()
{
    
    Direction d = _next;
    
    return d;
    
}

void Snake::set_centre(Direction input, Direction current)
{
      switch(input) {
                
                case CENTRE:
                
                // cannnot be CENTRE
                
                _next = current;
                
                break;
                
                case N:
                
                _next = input;
                
                break;
                
                case E:
                
                _next = input;
                
                break;
                
                case S:
                
                _next = input;
                
                break;
                
                case W:
                
                _next = input;
                
                break;
                
                default:
                
                _next = current;
                
                break;
                
                }
                
}  
void Snake::set_north(Direction input, Direction current)
{
    switch(input) {
            
                case CENTRE:
                
                _next = N;
                
                break;
                
                case N:
                
                _next = N;
                
                break;
                
                case E:
                
                _next = E;
                
                break;
                
                case S:
                
                // cannot be S
                
                _next = N;
                
                break;
                
                case W:
                
                _next = W;
                
                break;
                
                default:
                
                _next = current;
                                
                break;
                
                }
}
void Snake::set_east(Direction input, Direction current)
{
    
    switch(input) {
            
                case CENTRE:
                
                _next = E;
                
                break;
                
                case N:
                
                _next = N;
                
                break;
                
                case E:
                
                _next = E;
                
                break;
                
                case S:
                
                _next = S;
                
                break;
                
                case W:
                
                // cannot be W
                
                _next = E;
                
                break;
                
                default:
                
                _next = current;
                
                break;
                
                }
            
    
}
void Snake::set_south(Direction input, Direction current)
{
    switch(input) {
            
                case CENTRE:
                
                _next = S;
                
                break;
                
                case N:
                
                // cannot be N
                
                _next = S;
                
                break;
                
                case E:
                
                _next = E;
                
                break;
                
                case S:
                
                _next = S;
                
                break;
                
                case W:
                
                _next = W;
                
                break;
                
                default:
                
                _next = current;
                                
                break;
                
                }
                
            
}
void Snake::set_west(Direction input, Direction current)
{
    switch(input) {
            
                case CENTRE:
                
                _next = W;
                
                break;
                
                case N:
                
                _next = N;
                
                break;
                
                case E:
                
                // cannot be E
                
                _next = W;
                
                break;
                
                case S:
                
                _next = S;
                
                break;
                
                case W:
                
                _next = W;
                
                break;
                
                default:
                
                _next = current;
                
                break;
                
                }
                
}


void Snake::set_current_direction(Direction input)
{
    
    // if true the direction cannot be CENTRE
    
    if(get_snake_direction() == CENTRE && input == CENTRE) {
        
    _d = _d;
    
    }
    
    
    else {
        
        _d = get_snake_direction();
        
        }
    
    _current = _d;

}

Direction Snake::get_current_direction()
{
    
    Direction d = _current;
    
    return d;
    
}

void Snake::set_snake_position(Direction next)
{
    next = get_snake_direction();
    
    switch(next) {
        
            case N:
            
            // y increments (inverted due to N5110 class) x is static
        
            _pos.x = _pos.x;
            --_pos.y;
        
            break;
        
            case E:
            
            // x increments y is static
            
            ++_pos.x;
            _pos.y = _pos.y;
        
            break;
        
            case S:
            
            // y decrements x is static
            
            _pos.x = _pos.x;
            ++_pos.y;
        
            break;
        
            case W:
            
            // x decrements y is static
            
            --_pos.x;
            _pos.y = _pos.y;
        
            break;
            
            default:
            
            _pos.x = _pos.x;
            _pos.y = _pos.y;
            
            break;
            
            }
            
}

Vector2D Snake::get_snake_position()
{
    
    Vector2D pos = _pos;
    
    return pos; 
    
}

 
 // FSM Attempt
 
 /* 
    int state = N;
     
    StateDirection fsm[4] = {
        
    {N,{N,E,N,W}},  
    {E,{N,E,S,E}},  
    {S,{S,E,S,W}}, 
    {W,{N,W,S,W}} 
     
};

    _direction = fsm[state].output;  // set ouput depending on current state
    state = fsm[state].nextState[input];  // read input and update curent state
      */
        

            