#include "SnakeEngine.h"

///////////////// constructor/destructor /////////////////

SnakeEngine::SnakeEngine()
{

}

SnakeEngine::~SnakeEngine()
{

}
///////////////// global methods /////////////////

int g_tail_length()
{
    
    extern int g_tl;
    
    return g_tl;
    
}

void g_frame_time(int frame_time)
{
    
    g_ft = frame_time;
        
}


///////////////// public methods /////////////////

void SnakeEngine::init(Direction in, Direction cur, int snake_pos_x, int snake_pos_y, int n_frames)
{
    _snake_pos_x = snake_pos_x; 
    _snake_pos_y = snake_pos_y;
    _in = in;
    _cur = cur;
    _n_frames = n_frames;
    g_frame_time(_n_frames);
    
    _snake.init(_in, _cur, _snake_pos_x, _snake_pos_y);
    
    _food.init(true);
    
}

void SnakeEngine::update(Gamepad &pad)
{
    bool food_col;
    int food_spawn_time;
    ++g_engine_fc;
    
    increase_speed(5, 1.1);
    food_spawn_time = food_spawning_time(3);
    _snake.update(_in, _cur);
    printf("Spawn time %i \n", food_spawn_time);
    // printf("Frame Time %i \n", g_ft);
    
    _food.update(_collision, food_spawn_time);
    food_col = detect_food_collision(pad);
    _collision = food_col;
    set_tail_length(food_col);
    set_tail_array(pad);
    g_wall = detect_wall_collision(pad);
    //printf("%i%", g_wall);

}


void SnakeEngine::draw(N5110 &lcd)
{
    
    // puts frame around the game area
    
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
    lcd.setContrast(0.5);
    
    // draws food to lcd
    
    _food.draw(lcd);
    
    // draws snake head to lcd
    
    _snake.draw(lcd);
    
    // draws snake tail to lcd
    
    draw_tail(lcd);
    
}


void SnakeEngine::draw_tail(N5110 &lcd)
{
    int length = g_tl;
    int c;
    c = g_engine_fc % 2;
    int i;
    int x;
    int y;
    
    //printf("Odd/Even %i \n", c);
    
    // runs through each segment in the tail and draws to the lcd
    
    for(i=0; i<=length; ++i) {
    
    // when odd draw odd array
            
    if(c == 1) {
        
        x = g_odd_array_x[i];
        y = g_odd_array_y[i];
        
        lcd.setPixel(x,y,true);
                
        }
        
        // when even draw the even array
        
        else if (c == 0) {
        
            x = g_even_array_x[i];
            y = g_even_array_y[i];
            
            lcd.setPixel(x,y,true);
                        
            }
            
        }
}


void SnakeEngine::get_input(Gamepad &pad)
{
    
    _in = pad.get_direction();
    
}

bool SnakeEngine::detect_food_collision(Gamepad &pad)
{
    Vector2D snake_pos = _snake.get_snake_position();
    Vector2D food_pos = _food.get_food_position();
    
    bool success_flag = false;
    
    // when the position of the head and food are the same return true
    
    if((snake_pos.x == food_pos.x) && (snake_pos.y == food_pos.y)) {
        
        success_flag = true;
        
        }
        
        else {
            
            success_flag = false;
            
            }
        
    return success_flag;
    
}
bool SnakeEngine::detect_wall_collision(Gamepad &pad)
{
    
    Vector2D snake_pos = _snake.get_snake_position();

    bool success_flag = false;
    
    // when an snake position is at an edge return true
    
    if((snake_pos.x == (0 || 84)) || (snake_pos.y == (0 || 48))) {
        
        success_flag = true;
        
        }
        
        return success_flag;
    
}


void SnakeEngine::set_tail_length(bool collision_detected)
{
    // when a collision is detected increment the tail length
    
    if(collision_detected) {
        
        ++g_tl;
        
        }
        
        else {
            
            g_tl = g_tl;
            
            }
            
}

int SnakeEngine::get_tail_length()
{
    
    int length = g_tl;
    
    return length;
    
}

void SnakeEngine::set_odd_array(Gamepad &pad)
{
    
    int i;
    int length = g_tl;
    
    extern int g_even_array_x[100];
    extern int g_even_array_y[100];
    
    Vector2D pos = _snake.get_snake_position();
    
    // sets the first value in the array to the new position
    
    g_even_array_x[0] = pos.x;
    g_even_array_y[0] = pos.y;
    
    // starting from the last element in the arrays work back to zero
    
    for(i = length; i >= 0; --i) {
        
        // switch positions of the indexes adding the new head position
        
        if(i > 0) {
            
        g_odd_array_x[i] = g_even_array_x[i-1];
        g_odd_array_y[i] = g_even_array_y[i-1];
        
        }

        // when snake has no length position 0 is the new position

        else if(i == 0) {
                        
            g_odd_array_x[0] = pos.x;
            g_odd_array_y[0] = pos.y;
            
            }
        
    }
    
}

void SnakeEngine::set_even_array(Gamepad &pad)
{
    
    int i;
    int length = g_tl;
    
    extern int g_odd_array_x[100];
    extern int g_odd_array_y[100];
    
    Vector2D pos = _snake.get_snake_position();
    
    // sets the first value in the array to the new position
   
    g_odd_array_x[0] = pos.x;
    g_odd_array_y[0] = pos.y;

    // starting from the last element in the arrays work back to zero
    
    for(i = length; i >= 0; --i) {
        
        // switch positions of the indexes adding the new head position

        if(i > 0) {
            
        g_even_array_x[i] = g_odd_array_x[i-1];
        g_even_array_y[i] = g_odd_array_y[i-1];
        
        }
        
        // when snake has no length position 0 is the new position

        else if(i == 0) {
            
            g_even_array_x[0] = pos.x;
            g_even_array_y[0] = pos.y;
            
            }

    }
    
}


void SnakeEngine::set_tail_array(Gamepad &pad)
{
    
    int c = g_engine_fc % 2;
    
    // when the frame counter is odd set odd array
    
    if(c == 1) {
        
        set_odd_array(pad);
        
        }
        
        // when the frame counter is even set even array
        
        else if (c == 0) {
            
            set_even_array(pad);
            
            }
            
}

int SnakeEngine::food_spawning_time(int frame_decrementer)
{
    
    int c = 0;
    
    // c is equal to the tail length - an incrementer such that c is never more
    // than 0 and n = frame decremtner away from 0 such that the logic 
    // c == 0 works
    
    c = g_tl - g_n;
    
    //printf("C = %i", c);
    
    // the frame periodity must be more than 100 to ensure the game reamains playable
    
    if((c == 0) && (g_ft > 100)) {
        
        g_n = g_n + frame_decrementer;
        
        g_ft -= 10;
        
        frame_decrementer += frame_decrementer;
         
        }
    
    return g_ft;
    
}

void SnakeEngine::increase_speed(int resetter, float speed_decrementer)
{
    
    int c = 0;
    c = g_tl - g_n;
    if(g_tl == 0) {
        
        g_speed = 0.4;
            
        }

    if(c == 0) {
        
        g_n = g_n + resetter;
        
        g_speed = g_speed/speed_decrementer;
        
        resetter += resetter;
        
        }
        
}

