#include "Food.h"

///////////////// constructor/destructor /////////////////

Food::Food()
{

}

Food::~Food()
{

}

///////////////// global methods /////////////////

int g_frame_counter()
{
    
    extern int g_fc;
    
    return g_fc;
    
}

///////////////// public methods /////////////////


void Food::init(bool collision)
{
    
    int frame_count = g_frame_counter();
    
    set_food_position(frame_count, 150, collision);
    
}

void Food::update(bool collision, int n_frames) 
{
    // increment frame counter
    
    ++g_fc;
    
    int frame_count = g_frame_counter();
    
    set_food_position(frame_count, n_frames, collision);
         
}
  
void Food::draw(N5110 &lcd) 
{

    lcd.setPixel(_x,_y,true);
    
}     


Vector2D Food::get_rand_pos()
{
    
    Vector2D r;
    
    srand(time(NULL));
    
    // get random variables within screen dimensions 0-83, 0-47
    
    r.x = rand() % 83;
    r.y = rand() % 47;
    
    return r;
    
}

void Food::set_food_position(int set_frames, int number_frames, bool collision)
{
    //_number_frames = number_frames;
    
    Vector2D pos = get_rand_pos();
    
    // check if collision with snake has occured
    
    if(collision) {
        
        _x = pos.x;
        _y = pos.y;
        
        
        // reset frame counter to 0
        g_fc = 0;
        
        }
        
        // check if required number of frames has elapsed 
           
    else if((set_frames == number_frames) || (set_frames == 0)) {
        
        _x = pos.x;
        _y = pos.y;
        
        // reset frame counter to 0
        
        printf("Frames Past %i \n ", g_fc);

        g_fc = 0;
        
        }
        
        else {
            
            _x = _x;
            _y = _y;
            
            }
        
        
}

Vector2D Food::get_food_position()
{
    
    Vector2D p = {_x, _y};
    
    return p;
    
}