#ifndef TESTS_H
#define TESTS_H

#include "Asteroid-test.h"
#include "Spaceship-test.h"

/**
 * @brief Run all the tests for this game
 *
 * @returns The number of tests that failed
 */
int Run_tests()
{
    int tests_failed = 0; // number of tests that failed

////////////////////Asteroid testing////////////////////////////

   // Run the Asteroid_test_movement test
    printf(".....Testing Asteroid_movement.....\n");
    bool Asteroid_test_passed = Asteroid_movement();

    // Print out the result of all tests in Asteroid_movement
    if (Asteroid_test_passed) {
        printf("...PASSED!\n\n");
    }
    else {
        printf("...FAILED!\n\n");
        ++tests_failed; // Increase failures
    }
    
////////////////////Spaceship testing////////////////////////////

    // Run the Spaceship_test_movement test
    printf(".....Testing Spaceship_movement.....\n");
    bool Spaceship_test_passed = Spaceship_movement();
    
    // Print out the result of all tests in Spaceship_movement
    if (Spaceship_test_passed) {
        printf("...PASSED!\n\n");
    }
    else {
        printf("...FAILED!\n\n");
        ++tests_failed; // Increase failures
    }
 
 
 
    //summary of the tests
    if (tests_failed > 0) {
        printf("%d tests FAILED!\n", tests_failed);
    }
    else {
        printf("All tests passed!\n");
    }

    return tests_failed;
}

#endif