/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Reham Faqehi
Username: Fy15raf
Student ID Number: 200982112
Date: 03/05/2018
*/


///////// pre-processor directives ////////
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "GameEngine.h"
#include "tests.h"
/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad g_pad;
GameEngine game;

///////////// prototypes ///////////////
void init();
void render();
void welcome();
void gameOver();

///////////// functions ////////////////
int main()
{
    //game will excute if all tests passed
#ifdef ALL_TESTS_H
    int failures = Run_tests();

    if(failures > 0) return failures;
#endif

    int fps = 8;  // frames per second
    int sleep=0;
    init();     // initialise
    welcome();  // display welcome screen till the user press start to start the game
    
    //debugging
    printf("\n....THE GAME STARTED :)..... \n\n");

    render();  // drawing the initial frame
    wait(1.0f/fps);  // wait for one frame period


    // game loop executes
    while (1) {
        

        // green LEDs turn on and red LEDs turn off
        g_pad.led(1, 0);
        g_pad.led(4, 0);
        g_pad.led(3, 2);
        g_pad.led(6, 2);

        game.read_input(g_pad);
        game.update(g_pad);
        render();
        wait(1.0f/fps);

        while(g_pad.check_event(Gamepad::BACK_PRESSED) == true || sleep ==1) {

            printf("Waiting to contienue.....\n");

            sleep=1;
            // green LEDs turn off and red LED turn on
            g_pad.led(1, 2);
            g_pad.led(4, 2);
            g_pad.led(3, 0);
            g_pad.led(6, 0);
            //stop the game seconds
            game.time_stop();
            //sleep();
            //check if start button has been pressed to continue playing
            if(g_pad.check_event(Gamepad::START_PRESSED) == true) {
                sleep=0;
                break;
            }
        }
        if (game.check_gameOver()==1) { // if check_gameOver() function return 1 gameOver screen will be shown 
            //debugging
            printf("\n\n ....End of the game :)..... \n\n");

            lcd.clear();
            gameOver(); //game over screen will be shown with travelling period that has been reached 
            
            // reset to play again 
            game.reset_gameOver();
            init(); 
            render();
            
            //debugging
            printf("\n\n ....playing the game again :)..... \n\n");
            
        }
    }

}

// initialies all classes and libraries
void init()
{
    //initialise LCD and Gamepad first
    lcd.init();
    lcd.setContrast(0.5);
    g_pad.init();
    // initialise the game
    game.init();
}

//function to draw the frames on the LCD
void render()
{
    // first clear screen, re-draw and then refresh the LCD
    lcd.clear();
    game.draw(lcd);
    lcd.refresh();
}

// simple welcoming screen before starting the game
void welcome()
{

    lcd.printString("   Spaceship!    ",0,1);
    lcd.printString("   Press Start ",0,4);
    lcd.refresh();

    //flashing LEDs until start button is pressed
    while ( g_pad.check_event(Gamepad::START_PRESSED) == false) {
        g_pad.leds_on();
        wait(0.1);
        g_pad.leds_off();
        wait(0.1);
    }
}

// game over screen after the end of the game
void gameOver()
{
    //game over secreen will be shown until start button is pressed
    while ( g_pad.check_event(Gamepad::START_PRESSED) == false) {
    lcd.printString("  Game Over!! ",0,1);
    //print the maximum recorded seconds
    game.print_travel_time(lcd);
    lcd.refresh();
    }

}




