#ifndef SPACESHIP_H
#define SPACESHIP_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Spaceship Class
* @brief class create the Spaceship 
* @author Reham Faqehi  
* @date May, 2018  */

class Spaceship
{
public:

    /** Constructor */ 
    Spaceship();
    
    /** Destructor */
    ~Spaceship();
    
    /** Initialise the Spaceship position,
    * speed and number of collisions.           
    */   
    void init();
    
    /** Draw sprite for the Spaceship shape 
    * @param LCD object (N5110)          
    */   
    void draw(N5110 &lcd);
    
    /** Update the Spaceship movements
    * @param Direction d and magnitude (float)
    */
    void update(Direction d,float mag);
    
    /** Get the Spaceship position
    * @return the current position
    */ 
    Vector2D get_pos();
    
    /** Increase the number of 
    * collisions
    */
    void add_collisions();
    
    /** Get the number of 
    * collisions
    * @return the current collision number
    */
    int get_collisions();
    
    /** Draw sprite for 3 hearts
    * @param LCD object (N5110)          
    */   
    void drawFullHearts(N5110 &lcd);
    
    /** Draw sprite for 2 hearts only
    * @param LCD object (N5110)          
    */   
    void drawTwoHearts(N5110 &lcd);
    
    /** Draw sprite for 1 heart only
    * @param LCD object (N5110)          
    */   
    void drawOneHeart(N5110 &lcd);
    
private:

    int _x;
    int _y;
    int _speed;
    Vector2D p;
    int _collision;
  
};
#endif