#include "Spaceship.h"

Spaceship::Spaceship()
{

}

Spaceship::~Spaceship()
{

}

void Spaceship::init()
{
    //initialise the Spaceship position, speed and collisions 
    _x = 15 ;
    _y = HEIGHT/2 ;
    _speed = 1;
    _collision=0;
}

void Spaceship::draw(N5110 &lcd)
{
    int sprite[7][10] =   {

        { 0,1,1,1,1,0,0,0,0,0, },
        { 0,0,1,0,0,1,1,0,0,0, },
        { 0,0,0,1,0,0,0,1,1,0, },
        { 0,0,0,1,1,1,1,1,1,1, },
        { 0,0,0,1,0,0,0,1,1,0, },
        { 0,0,1,0,0,1,1,0,0,0, },
        { 0,1,1,1,1,0,0,0,0,0, },
    };
    lcd.drawSprite(_x,_y,7,10,(int *)sprite);
}

void Spaceship::update(Direction d,float mag)
{
    _speed = int(mag*10.0f); //shows how far from the center does the Spaceship move based on the joystick

    // update y and x values based on direction of joystick movement
    if (d == N) {
        _y-=_speed;
    } else if (d == S) {
        _y+=_speed;
    } else if (d == W) {
        _x-=_speed;
    } else if (d == E) {
        _x+=_speed;
    }


    // check the Spaceship coordinates so it doesn't go off screen
    if (_y < 1) {
        _y = 1;
    }
    if (_y > HEIGHT - 7) {
        _y = HEIGHT - 7;
    }
    if (_x < 1) {
        _x = 1;
    }
    if (_x > WIDTH - 9) {
        _x = WIDTH - 9;
    }
}

Vector2D Spaceship::get_pos()
{
    Vector2D p = {_x,_y};
    return p;
}

void Spaceship::add_collisions()
{
    _collision++;
}

int Spaceship::get_collisions()
{
    return _collision;
}

void Spaceship::drawFullHearts(N5110 &lcd)
{
    int sprite[5][17] =   {

        { 1,1,0,1,1,0,1,1,0,1,1,0,1,1,0,1,1, },
        { 1,1,1,1,1,0,1,1,1,1,1,0,1,1,1,1,1, },
        { 1,1,1,1,1,0,1,1,1,1,1,0,1,1,1,1,1, },
        { 0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0, },
        { 0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0,0, },
    };
    lcd.drawSprite(0,0,5,17,(int *)sprite);
}

void Spaceship::drawTwoHearts(N5110 &lcd)
{
    int sprite[5][17] =   {

        { 1,1,0,1,1,0,1,1,0,1,1,0,1,1,0,1,1, },
        { 1,1,1,1,1,0,1,1,1,1,1,0,1,0,1,0,1, },
        { 1,1,1,1,1,0,1,1,1,1,1,0,1,0,0,0,1, },
        { 0,1,1,1,0,0,0,1,1,1,0,0,0,1,0,1,0, },
        { 0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0,0, },
    };
    lcd.drawSprite(0,0,5,17,(int *)sprite);
}

void Spaceship::drawOneHeart(N5110 &lcd)
{
    int sprite[5][17] =   {

        { 1,1,0,1,1,0,1,1,0,1,1,0,1,1,0,1,1, },
        { 1,1,1,1,1,0,1,0,1,0,1,0,1,0,1,0,1, },
        { 1,1,1,1,1,0,1,0,0,0,1,0,1,0,0,0,1, },
        { 0,1,1,1,0,0,0,1,0,1,0,0,0,1,0,1,0, },
        { 0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0,0, },
    };
    lcd.drawSprite(1,1,5,17,(int *)sprite);
}