#ifndef SPACESHIP_TEST_H
#define SPACESHIP_TEST_H

/**
 * \brief Check that Spaceship object goes to correct position when it is updated
 * 
 * \returns true if all the tests passed
 */
bool Spaceship_movement()
{
  
    Spaceship S1;
    S1.init(); // x= 15  y=(HEIGHT/2)

    S1.update(N,2);//set Spaceship to move to the North with magnitude of 2 pixel -> y=(HEIGHT/2) will be changed to y=(HEIGHT/2)-speed and speed=meg*10

    Vector2D read_S1_pos = S1.get_pos();
    printf("Spaceship1 position x= %f, y= %f\n", read_S1_pos.x, read_S1_pos.y);  //print x and y pos.

    bool success_flag = true;
    
    // Fail the test if the position after updating is not equal to the expecting position
    if (read_S1_pos.x != 15 || read_S1_pos.y !=  (HEIGHT/2)-20) { // speed= (2)*10=20
        success_flag = false;
    }

///////////////another direction and meg to be tested ////////////////////////

    Spaceship S2;
    S2.init(); //// x= 15  y=(HEIGHT/2)

    S2.update(E,1); //set Spaceship to move toward East with magnitude of 1 pixel -> x=15 will be changed to x=15+speed and speed=meg*10

    Vector2D read_S2_pos = S2.get_pos();
    printf("Spaceship2 position x= %f, y= %f\n", read_S2_pos.x, read_S2_pos.y);  //print x and y pos.

    
    // Fail the test if the position after updating updating is not equal to the expecting position
    if (read_S2_pos.x != 15 +10 || read_S2_pos.y !=  (HEIGHT/2)) {// speed= (1)*10=10
        success_flag = false;
    }

    return success_flag;
}
#endif