#ifndef GameEngine_H
#define GameEngine_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Spaceship.h"
#include "Asteroid.h"

/** GameEngine Class
* @brief class to control the game functions 
* @author Reham Faqehi  
* @date May, 2018  */ 

class GameEngine
{

public:
    /** Constructor */ 
    GameEngine();
    
    /** Destructor */ 
    ~GameEngine();

    /** Initialise the game elements: 
    * Spaceship, asteroids, time, and 
    * game over value             
    */   
    void init();
    
    /** Read the direction and magnitude 
    * data from the joystick 
    * @param gamepad object (Gamepad) 
    */ 
    void read_input(Gamepad &g_pad);
    
    /** Draw the game elements: 
    * Spaceship, asteroids, hearts
    * and show the time 
    * @param LCD object (N5110) 
    */ 
    void draw(N5110 &lcd);
    
    /** Update the game elements: 
    * Spaceship, asteroids, the hearts
    * and the time 
    * @param gamepad object (Gamepad)
    */
    void update(Gamepad &pad);
    
    /** Draw the hearts
    * @param LCD object (N5110) 
    */ 
    void draw_hearts(N5110 &lcd);
    
    /** Check if it is the end of the game
    * @return the gameover value (int) 
    */
    int check_gameOver();
    
    /** Print the current time in sec
    * @param LCD object (N5110) 
    */
    void print_time(N5110 &lcd);
    
    /** Increase the time every 1 sec
    */
    void time_increment();
    
    /** Stop the time counter at 
    * the end of the game
    */
    void time_stop();
    
    /** Print the total time in sec
    * at the end of the game
    * @param LCD object (N5110) 
    */
    void print_travel_time(N5110 &lcd);
    
    /** Reset the time and 
    * game over value to play again
    */
    void reset_gameOver();
    

private:

    /** Check the collision with Asteroid 1
    * @param gamepad object (Gamepad)
    */
    void check_collision1(Gamepad &pad);
    
    /** Check the collision with Asteroid 2
    * @param gamepad object (Gamepad)
    */
    void check_collision2(Gamepad &pad);
    
    /** Check the collision with Asteroid 3
    * @param gamepad object (Gamepad)
    */
    void check_collision3(Gamepad &pad);
        
    int gameOver;
    Spaceship _Spaceship;
    Asteroid _asteroid1;
    Asteroid _asteroid2;
    Asteroid _asteroid3;
    Direction _d;
    float _mag;
    Timer time;
    int _time;

};

#endif
