#include "GameEngine.h"

GameEngine::GameEngine()
{

}

GameEngine::~GameEngine()
{

}


void GameEngine::init()
{
    //initialise game objects Spaceship and 3 asteroids with diffrent speeds
    _Spaceship.init();
    _asteroid1.init(2);
    _asteroid2.init(3);
    _asteroid3.init(4);
    time.reset();
    gameOver=0;
}


void GameEngine::read_input(Gamepad &pad)
{
    _d = pad.get_direction();
    _mag = pad.get_mag();
}


void GameEngine::draw(N5110 &lcd)
{
    // draw the game elements in the LCD
    _Spaceship.draw(lcd);
    _asteroid1.draw(lcd);
    _asteroid2.draw(lcd);
    _asteroid3.draw(lcd);

    //print the 3 hearts life
    draw_hearts(lcd);

    //print the recorded time in sec
    print_time(lcd);
}


void GameEngine::update(Gamepad &pad)
{

    //checking collisions with Asteroid 1, 2 and 3
    check_collision1(pad);
    check_collision2(pad);
    check_collision3(pad);

    //updating the display
    _Spaceship.update(_d,_mag);
    _asteroid1.update();
    _asteroid2.update();
    _asteroid3.update();

    //updating the time
    time_increment();
}


void GameEngine::check_collision1(Gamepad &pad)
{
    Vector2D _asteroid1_pos = _asteroid1.get_pos() ;
    Vector2D _Spaceship_pos = _Spaceship.get_pos();

    // check if the collision occers with Asteroid 1
    if ((_Spaceship_pos.x+10 >=_asteroid1_pos.x) &&( _Spaceship_pos.x+8 <_asteroid1_pos.x )) {

        if( ( _asteroid1_pos.y >= _Spaceship_pos.y) && ( _asteroid1_pos.y <= _Spaceship_pos.y+7) ||
                (_asteroid1_pos.y+6 >= _Spaceship_pos.y) &&(_asteroid1_pos.y+6 <= _Spaceship_pos.y+7 )) {

            _Spaceship.add_collisions();
            pad.tone(1500.0,0.5);        //tone
            pad.leds_on();               //LEDs flashing
            wait(0.5);
            pad.leds_off();
            //debugging 
            printf("((collision occurs))\n" );
        }
    }
}


void GameEngine::check_collision2(Gamepad &pad)
{

    Vector2D _asteroid2_pos = _asteroid2.get_pos();
    Vector2D _Spaceship_pos = _Spaceship.get_pos();

    // check if the collision occers with Asteroid 2
    if ((_Spaceship_pos.x+10 >=_asteroid2_pos.x) && (_Spaceship_pos.x+8 <_asteroid2_pos.x )) {

        if( (_asteroid2_pos.y >= _Spaceship_pos.y) && ( _asteroid2_pos.y <= _Spaceship_pos.y+7) ||
                (_asteroid2_pos.y+6 >= _Spaceship_pos.y) &&( _asteroid2_pos.y+6 <= _Spaceship_pos.y+7 )) {

            _Spaceship.add_collisions();
            pad.tone(1500.0,0.5);           //tone
            pad.leds_on();                  //LEDs flashing
            wait(0.5);
            pad.leds_off();
            //debugging 
            printf("((collision occurs))\n");
        }
    }
}


void GameEngine::check_collision3(Gamepad &pad)
{

    Vector2D _asteroid3_pos = _asteroid3.get_pos();
    Vector2D _Spaceship_pos = _Spaceship.get_pos();

    // check if the collision occers with Asteroid 3
    if ((_Spaceship_pos.x+10 >= _asteroid3_pos.x) &&( _Spaceship_pos.x+6 < _asteroid3_pos.x )) {

        if( (_asteroid3_pos.y >= _Spaceship_pos.y) &&( _asteroid3_pos.y <= _Spaceship_pos.y+7) ||
                ( _asteroid3_pos.y+6 >= _Spaceship_pos.y) &&(_asteroid3_pos.y+6 <= _Spaceship_pos.y+7 )) {

            _Spaceship.add_collisions();
            pad.tone(1500.0,0.5);           //tone
            pad.leds_on();                  //LEDs flashing
            wait(0.5);
            pad.leds_off();
            //debugging 
            printf("((collision occurs))\n");
        }
    }
}


void GameEngine::draw_hearts(N5110 &lcd)
{
    // get collision from Spaceship class
    int _Spaceship_collisions= _Spaceship.get_collisions();
    
    // reduce the hearts with each collision till the third collision the game ends   
    if (_Spaceship_collisions==0) {
        _Spaceship.drawFullHearts(lcd);
        
    } else if (_Spaceship_collisions ==1) {
        _Spaceship.drawTwoHearts(lcd);
        
    } else if (_Spaceship_collisions == 2) {
        _Spaceship.drawOneHeart(lcd);
        
    } else {
        gameOver=1;
        
    }
}


int GameEngine::check_gameOver()
{
    //stop the time and return if game over
    time.stop ();
    return gameOver;
}


void GameEngine::reset_gameOver(){
    
    //rest time and game over value to play again
    time.reset();
    gameOver=0;
}


void GameEngine::time_increment()
{
    //start and incrementing the time and read it
    time.start();
    _time = time.read();
}


void GameEngine::time_stop()
{
    //stop the time
    time.stop();
}


void GameEngine::print_time(N5110 &lcd)
{   
    // print the time
    char buffer1[11];
    sprintf(buffer1,"%4d",_time); //maximum time 9999
    lcd.printString(buffer1,60, 0);
}


void GameEngine::print_travel_time(N5110 &lcd)
{
    // print the time at the end of the game
    char buffer1[11];
    sprintf(buffer1,"  %4d sec",_time); //maximum time 9999
    lcd.printString(buffer1,0, 3);
}

