#ifndef stone_H
#define stone_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"


/** Asteroid Class
* @brief class create the Asteroids 
* @author Reham Faqehi  
* @date May, 2018  */


class Asteroid
{

public:

    /** Constructor */ 
    Asteroid();
    
    /** Destructor */
    ~Asteroid();
    
    /** Initialise the Asteroid position, and size.
    * @param speed value (float).           
    */   
    void init(float speed);
    
    /** Draw sprite for the Asteroid shape 
    * @param LCD object (N5110)     
    */ 
    void draw(N5110 &lcd);  
    
    /** Update the Asteroid position           
    */
    void update();
    
    /** Get the Asteroid position
    * @return the current position
    */ 
    Vector2D get_pos();

private:

    Vector2D _velocity;
    Vector2D p;
    int _size;
    int _x;
    int _y1;
};
#endif
