#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "rect.h"
#include "boom.h"
#include "bigboom.h"
#include "money.h"
#include "engine.h"
#include "help.h"


DigitalOut gpo(D0);
DigitalOut led(LED_RED);
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
engine engine;
help help11;


void init();
void welcome();
void render();
void draw(N5110 &lcd);



int main()
{
        init();
        draw(lcd);
 
while(1){
    
        engine.read_input(pad);
        engine.update(pad,lcd);
        render();
        wait(0.1);
        }
     
}
 
 
 
void draw(N5110 &lcd)
{
        lcd.clear();
        lcd.printString("     Boom",0,0);  
        lcd.printString("     Start",0,2);    
        lcd.printString("     Help",0,4);
        help11.draw_arrow(lcd);
        lcd.refresh();
        while(pad.check_event(Gamepad::Y_PRESSED) == true);
        
        //press START to start game
        do{
           engine.start(pad,lcd);
           }
        while(pad.check_event(Gamepad::START_PRESSED) == false);  
}   


void init()
{
        //initialise LCD and Gamepad 
        lcd.init();
        pad.init();
}

 
void render()
{
        // clear screen, re-draw and refresh
        lcd.clear();  
        engine.draw(lcd);
        lcd.refresh();
}
