#include "help.h"
help::help()
{
}
help::~help()
{
}

void help::update(Gamepad &pad,N5110 &lcd)
{               
        model_1(pad,lcd);  //determine which model to enter
        model_2(pad,lcd); 
}
void help::model_1(Gamepad &pad,N5110 &lcd)
{       
        if (pad.check_event(Gamepad::Y_PRESSED) == true) {
        lcd.clear();
        
        lcd.printString("     Boom",0,0);  
        lcd.printString("     Start",0,2);    
        lcd.printString("     Help",0,4);
        arrow_y = 0;
        draw_arrow(lcd);
        lcd.refresh();
        
        choice=0;  //choice = 0 means the first model"game"
        }
        prevent_page(pad,lcd);
}

void help::model_2(Gamepad &pad,N5110 &lcd)
{
        if (pad.check_event(Gamepad::A_PRESSED) == true)
        {
        lcd.clear();
        
        lcd.printString("     Boom",0,0);  
        lcd.printString("     Start",0,2);    
        lcd.printString("     Help",0,4);
        arrow_y = 15;
        draw_arrow(lcd);
        lcd.refresh();
        
        choice=1;  //choice = 1 means the second model "help"
        } 
        
        //control the page to move on or move backward
        page_back(pad,lcd);
        page_on(pad,lcd);
    
}

void help::prevent_page(Gamepad &pad,N5110 &lcd)
{
       if((choice == 0) and (pad.check_event(Gamepad::B_PRESSED) == true))
       {
        page = 0;
        }
}


void help::page_on(Gamepad &pad,N5110 &lcd)
{
        if((choice ==1)and(pad.check_event(Gamepad::B_PRESSED) == true))
        {
        lcd.clear();
        page=page+1;  //every time press B,page +1, then move to the next page
        
        if(page>3){page=3;} //limit the page not go outside
        if(page==1){statement1(lcd);}
        else if(page==2){statement2(lcd);}
        else if (page==3){statement3(lcd);}
        lcd.refresh();
        }
        
}

void help::page_back(Gamepad &pad,N5110 &lcd)
{
        if((choice == 1) and (pad.check_event(Gamepad::X_PRESSED) == true))
        {
        lcd.clear();
        page=page-1;   //press X then the page goes backward
        
        if(page <0){page = 0;} //limit the page not loweer than 0;
        if(page==1){statement1(lcd);}
        else if(page==2){statement2(lcd);}
        else if (page==3){statement3(lcd);}
        //from the help to the main menu
        else if(page==0)
        {    
        lcd.printString("     Boom",0,0);  
        lcd.printString("     Start",0,2);    
        lcd.printString("     Help",0,4);
        arrow_y = 15;
        draw_arrow(lcd);
        }
        lcd.refresh();
        }    
    
}

void help::draw_arrow(N5110 &lcd)
{
        lcd.drawRect(arrow_x,arrow_y+17,15,5,FILL_TRANSPARENT);
        lcd.drawRect(arrow_x+15,arrow_y+19,5,1,FILL_TRANSPARENT);
        lcd.drawRect(arrow_x+15,arrow_y+18,4,1,FILL_TRANSPARENT);
        lcd.drawRect(arrow_x+15,arrow_y+20,4,1,FILL_TRANSPARENT);
        lcd.drawRect(arrow_x+15,arrow_y+17,3,1,FILL_TRANSPARENT);
        lcd.drawRect(arrow_x+15,arrow_y+21,3,1,FILL_TRANSPARENT);
        lcd.drawRect(arrow_x+15,arrow_y+16,2,1,FILL_TRANSPARENT);
        lcd.drawRect(arrow_x+15,arrow_y+22,2,1,FILL_TRANSPARENT);
        lcd.drawRect(arrow_x+15,arrow_y+15,1,1,FILL_TRANSPARENT);
        lcd.drawRect(arrow_x+15,arrow_y+23,1,1,FILL_TRANSPARENT);   
}

void help::statement1(N5110 &lcd)
{
        lcd.clear();
        lcd.printString("Press START to",0,0); 
        lcd.printString("start game",0,1);
        lcd.printString("Press B to the",0,2);
        lcd.printString("next page",0,3);
        lcd.printString("Press X to the",0,4);
        lcd.printString("previous page",0,5);
        lcd.refresh();
}
void help::statement2(N5110 &lcd)
{
        lcd.clear();
        lcd.printString("This is a very",0,0); 
        lcd.printString("easy game :)",0,1);
        lcd.printString("Collecting $$$",0,2);
        lcd.printString("to get scores",0,3);
        lcd.printString("You will lose",0,4);
        lcd.printString("scores when",0,5);
        lcd.refresh();

}
void help::statement3(N5110 &lcd)
{
        lcd.clear();
        lcd.printString("hits a boom :(",0,0); 
        lcd.printString("!!!WARNING!!!",0,1);
        lcd.printString("!!!WARNING!!!",0,2);
        lcd.printString("If you hit a",0,3);
        lcd.printString("   BIG BOOM",0,4);
        lcd.printString("   GAME OVER",0,5);
        lcd.refresh();

}



