#ifndef ENGINE_H
#define ENGINE_H
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "rect.h"
#include "boom.h"
#include "bigboom.h"
#include "money.h"
#include "help.h"
class engine
{
public:
    engine();
    ~engine();
   
    void read_input(Gamepad &pad);
    void update(Gamepad &pad,N5110 &lcd);
    void draw(N5110 &lcd);
    void start(Gamepad &pad,N5110 &lcd);
    

private:
    
    void check_boom_collision(Gamepad &pad,N5110 &lcd);
    void check_money_collision(Gamepad &pad,N5110 &lcd);
    void check_boom_right_collision(Gamepad &pad,N5110 &lcd);
    void check_boom_left_collision(Gamepad &pad,N5110 &lcd);
    void check_bigboom_collision(Gamepad &pad,N5110 &lcd);
    
    void check_bigboom_pos(Gamepad &pad);
    void check_money_pos(Gamepad &pad);
    void check_rect_pos(Gamepad &pad);
    void check_boom_pos(Gamepad &pad);
    

    void print_scores(N5110 &lcd);
    
    
    rect _rect;
    int _speed;
    
    boom _boom;
    money _money;
    bigboom _bigboom;
    help _help;
    Direction _d;
    float _mag;


};




#endif