#include "engine.h"
engine::engine()
{
}
engine::~engine()
{
}

void engine::draw(N5110 &lcd)
{  
    //draw and re-draw rectangle, boom and money on the screen
    _rect.draw(lcd); 
    _boom.draw(lcd);
    _money.draw(lcd);
    _bigboom.draw(lcd);    
}

void engine::read_input(Gamepad &pad)
{
    _d = pad.get_direction();
    _mag = pad.get_mag();
}


void engine::update(Gamepad &pad,N5110 &lcd)
{
     
    _rect.update(_d,_mag); //get the position of rect when jopystick moves
    
    //boom and money will keep moving with initial settings
    _boom.update();      
    _money.update();
    _bigboom.update();
    
    check_money_pos(pad);
    check_rect_pos(pad);
    check_boom_pos(pad);
    check_bigboom_pos(pad);
   
    check_money_collision(pad,lcd);
    check_boom_collision(pad,lcd); 
    check_boom_right_collision(pad,lcd);
    check_boom_left_collision(pad,lcd);
    check_bigboom_collision(pad,lcd);
   
}

void engine::check_money_pos(Gamepad &pad)
{
    Vector2D money_pos = _money.get_pos();
    
    if (money_pos.y > 48) {
        money_pos.y = 0;
        money_pos.x = rand()%84;  //the money will back to top with random x position
    }

    //avoid money out of the screen
    if (money_pos.x+4 >= 84) {
        money_pos.x = 80;
    }
    
    if (money_pos.x <2){
        money_pos.x = 3;
    }  
    _money.set_pos(money_pos); 
    
    
}

void engine::check_boom_pos(Gamepad &pad)
{
    Vector2D boom_pos = _boom.get_pos();
    if (boom_pos.y > 48) {  
        boom_pos.y = 0;
        boom_pos.x = rand()%84;    //boom will back to top with random x position 
    }
    
    //avoid boom go outside of the screen
    if (boom_pos.x >= 82) {
        boom_pos.x = 81;
    }
    
    if (boom_pos.x <2){
        boom_pos.x = 3;
    }
   _boom.set_pos(boom_pos); 
}

void engine::check_bigboom_pos(Gamepad &pad)
{
    Vector2D bigboom_pos = _bigboom.get_pos();
    if (bigboom_pos.y > 48) {  
        bigboom_pos.y = 0;
        bigboom_pos.x = rand()%84;    //boom will back to top with random x position 
    }
    
    //avoid boom go outside of the screen
    if (bigboom_pos.x >= 80) {
        bigboom_pos.x = 79;
    }
    
    if (bigboom_pos.x <4){
        bigboom_pos.x = 4;
    }
   _bigboom.set_pos(bigboom_pos); 
}

void engine::check_rect_pos(Gamepad &pad)
{
    Vector2D rect_pos = _rect.get_pos();
    
    //keep the rect moving inside the screen
    if (rect_pos.x < 1) {
        rect_pos.x = 1;
    }
    if (rect_pos.x > 74) {
        rect_pos.x = 74;
    }
    _rect.set_pos(rect_pos);  


}
void engine::check_boom_collision(Gamepad &pad,N5110 &lcd)
{
    Vector2D boom_pos = _boom.get_pos();
    Vector2D rect_pos = _rect.get_pos();
    
    if (
        (boom_pos.x >= rect_pos.x)and
        (boom_pos.x+3 <= rect_pos.x+10)and
        (boom_pos.y == 40))
        {
         boom_pos.y = 0;  
         boom_pos.x = rand()%84; 
         pad.tone(4450.0,1);
         _rect.minus_score();
         }

    _boom.set_pos(boom_pos); 
    _rect.set_pos(rect_pos);      
}

//to check whether the edge of the boom hit rect
void engine::check_boom_left_collision(Gamepad &pad,N5110 &lcd)
{
    Vector2D boom_pos = _boom.get_pos();
    Vector2D rect_pos = _rect.get_pos();
    
    if (((boom_pos.x == rect_pos.x+10)and
        (boom_pos.y == 40))or
        ((boom_pos.x-1 == rect_pos.x+10)and
        (boom_pos.y-1 == 40))) 
        {
         boom_pos.y = 0;  
         boom_pos.x = rand()%84; 
         pad.tone(4450.0,1);
         _rect.minus_score();
        }

    _boom.set_pos(boom_pos); 
    _rect.set_pos(rect_pos);      
}

void engine::check_boom_right_collision(Gamepad &pad,N5110 &lcd)
{
    Vector2D boom_pos = _boom.get_pos();
    Vector2D rect_pos = _rect.get_pos();
     
    if (((boom_pos.x+3 == rect_pos.x)and
        (boom_pos.y == 40))or
        ((boom_pos.x+4 == rect_pos.x)and
        (boom_pos.y-1 == 40)))
        { 
         boom_pos.y = 0;  
         boom_pos.x = rand()%84; 
         pad.tone(4450.0,1);
         _rect.minus_score();
         }

    _boom.set_pos(boom_pos); 
    _rect.set_pos(rect_pos);      
}

//only when the bottom of the big boom hit the rect
//will lead to game over
void engine::check_bigboom_collision(Gamepad &pad,N5110 &lcd)
{
    Vector2D bigboom_pos = _bigboom.get_pos();
    Vector2D rect_pos = _rect.get_pos();
    
    if ((bigboom_pos.x >= rect_pos.x)and
        (bigboom_pos.x <= rect_pos.x+10)and
        (bigboom_pos.y+7 == 41))
       {
        bigboom_pos.y = 0;  
        bigboom_pos.x = rand()%84; 
        pad.tone(4450.0,1);
        engine::print_scores(lcd);
        _rect.init_score();
         }

    _bigboom.set_pos(bigboom_pos); 
    _rect.set_pos(rect_pos);      
}

void engine::check_money_collision(Gamepad &pad,N5110 &lcd)
{
    Vector2D rect_pos = _rect.get_pos();
    Vector2D money_pos = _money.get_pos();
    if ((money_pos.x >= rect_pos.x+3)and
        (money_pos.x+4 <= rect_pos.x+7)and
        (money_pos.y+2 == 40))
       {
        money_pos.y = 0;  
        money_pos.x = rand()%84; 
        pad.tone(1750.0,0.5);
        _rect.add_score();
         }

    _money.set_pos(money_pos); 
    _rect.set_pos(rect_pos);      
}


void engine::print_scores(N5110 &lcd)
{
    int rect_score = _rect.get_score();
    char buffer1[14];
    
    //print score
    lcd.clear();
    sprintf(buffer1,"%2d",rect_score);
    lcd.printString("   Score: ",3,3);
    lcd.printString(buffer1,35,5);
    
    lcd.printString("   Game Over",0,1);  
    lcd.refresh();
    wait(3);

}

void engine::start(Gamepad &pad,N5110 &lcd){
    _help.update(pad,lcd);  
}
