#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"


/** The Food class
* @brief Stores the position of the food to be eaten and randomises its location
* @author Andrew J. Moore
* @date May, 2018
*/

class Food
{
public:

    /** Constructor */
    Food();
    
    /** Destructor */
    ~Food();

    /** Initialisation function
    * @param the inital starting position for the food, given in X and Y (int)
    */
    void init(int x, int y);

    /** Gets the current X coordinate of the food
    * @return the current X coordinate
    */
    int getX();
    
    
    /** Gets the current Y coordinate of the food
    * @return the current Y coordinate
    */
    int getY();
    
    
    /** Randomises the current location of the food   */
    void random();

private:

    //Private Variables
    int _x;
    int _y;
};