#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"


//Snek has been named as such to avoid confusion when refering to or declaring snake

/** The Snake class
* @brief Stores the location of all the snake segments, handles movement and growth of the snake
* @author Andrew J. Moore
* @date May, 2018
*/

class Snek
{
public:

    /** Constructor */
    Snek();

    /** Destructor */
    ~Snek();

    /** Initialisation function
    * @param the inital starting position for the snake's head, given in X and Y (int)
    */
    void init(int x, int y);

    /** Updates the location of the snake
    * @param the joystick's current direction (Direction)
    */
    void update(Direction d);

    /** Gets an X coordinate of the snake
    * @param the position in the snake being referenced (int)
    * @return the value of _x[ref]
    */
    int getX(int ref);

    /** Gets an Y coordinate of the snake
    * @param the position in the snake being referenced (int)
    * @return the value of _y[ref]
    */
    int getY(int ref);

    /** Gets the length of the snake
    * @return the value of _length
    */
    int getLength();

    /** Grows the snake in length */
    void grow();

private:

    //Private Variables
    int _length;
    int _speed;
    int _x[484];        //484 is the maximum size of the grid therefor max size of the snake
    int _y[484];
    char _oldDirection;

    //Private Methods
};
